/*
 * Decompiled with CFR 0.152.
 */
package com.beowulfchain.beowulfj.base.models;

import com.beowulfchain.beowulfj.exceptions.BeowulfInvalidTransactionException;
import com.beowulfchain.beowulfj.interfaces.ByteTransformable;
import eu.bittrade.crypto.core.CryptoUtils;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.joou.UInteger;

public abstract class Ripemd160
implements ByteTransformable,
Serializable {
    private static final long serialVersionUID = 7984783145088522082L;
    private byte[] hashValue;

    public Ripemd160(String hashValue) {
        this.setHashValue(hashValue);
    }

    public int getNumberFromHash() {
        byte[] fourBytesByte = new byte[4];
        System.arraycopy(this.hashValue, 0, fourBytesByte, 0, 4);
        return ByteBuffer.wrap(fourBytesByte).order(ByteOrder.BIG_ENDIAN).getInt();
    }

    public UInteger getHashValue() {
        return UInteger.valueOf((long)CryptoUtils.readUint32((byte[])this.hashValue, (int)4));
    }

    public void setHashValue(byte[] hashValue) {
        this.hashValue = hashValue;
    }

    public void setHashValue(String hashValue) {
        this.hashValue = CryptoUtils.HEX.decode((CharSequence)hashValue);
    }

    @Override
    public byte[] toByteArray() throws BeowulfInvalidTransactionException {
        return this.hashValue;
    }

    public String toString() {
        return CryptoUtils.HEX.encode(this.hashValue);
    }
}

