/*
 * Decompiled with CFR 0.152.
 */
package com.beowulfchain.beowulfj.base.models;

import com.beowulfchain.beowulfj.base.models.BlockId;
import com.beowulfchain.beowulfj.base.models.FutureExtensions;
import com.beowulfchain.beowulfj.configuration.BeowulfJConfig;
import com.beowulfchain.beowulfj.enums.PrivateKeyType;
import com.beowulfchain.beowulfj.exceptions.BeowulfInvalidTransactionException;
import com.beowulfchain.beowulfj.fc.TimePointSec;
import com.beowulfchain.beowulfj.interfaces.SignatureObject;
import com.beowulfchain.beowulfj.protocol.operations.Operation;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import eu.bittrade.crypto.core.CryptoUtils;
import java.io.Serializable;
import java.security.InvalidParameterException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.joou.UInteger;
import org.joou.UShort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Transaction
implements Serializable {
    private static final long serialVersionUID = -3834759301983200246L;
    private static final Logger LOGGER = LoggerFactory.getLogger(Transaction.class);
    @JsonProperty(value="ref_block_num")
    protected UShort refBlockNum;
    @JsonProperty(value="ref_block_prefix")
    protected UInteger refBlockPrefix;
    @JsonProperty(value="expiration")
    protected transient TimePointSec expirationDate;
    @JsonProperty(value="operations")
    protected transient List<Operation> operations;
    @JsonProperty(value="extensions")
    protected transient List<FutureExtensions> extensions;
    @JsonProperty(value="created_time")
    protected Long createdTime;

    @JsonCreator
    public Transaction(@JsonProperty(value="ref_block_num") UShort refBlockNum, @JsonProperty(value="ref_block_prefix") UInteger refBlockPrefix, @JsonProperty(value="expiration") TimePointSec expirationDate, @JsonProperty(value="operations") List<Operation> operations, @JsonProperty(value="extensions") List<FutureExtensions> extensions, @JsonProperty(value="created_time") Long createdTime) {
        this.setRefBlockNum(refBlockNum);
        this.setRefBlockPrefix(refBlockPrefix);
        this.setExpirationDate(expirationDate);
        this.setOperations(operations);
        this.setExtensions(extensions);
        this.setCreatedTime(createdTime);
    }

    public Transaction(BlockId blockId, List<Operation> operations, List<FutureExtensions> extensions) {
        this.setRefBlockNum(UShort.valueOf((int)(blockId.getNumberFromHash() & 0xFFFF)));
        this.setRefBlockPrefix(blockId.getHashValue());
        this.setExpirationDate(new TimePointSec(System.currentTimeMillis() + BeowulfJConfig.getInstance().getMaximumExpirationDateOffset() - 60000L));
        this.setOperations(operations);
        this.setExtensions(extensions);
        this.setCreatedTime(null);
    }

    @VisibleForTesting
    protected Transaction() {
    }

    public List<FutureExtensions> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<FutureExtensions>();
        }
        return this.extensions;
    }

    public void setExtensions(List<FutureExtensions> extensions) {
        this.extensions = extensions;
    }

    public List<Operation> getOperations() {
        return this.operations;
    }

    public void setOperations(List<Operation> operations) {
        if (operations == null || operations.isEmpty()) {
            throw new InvalidParameterException("At least one Operation is required.");
        }
        this.operations = operations;
    }

    public UShort getRefBlockNum() {
        return this.refBlockNum;
    }

    public void setRefBlockNum(UShort refBlockNum) {
        this.refBlockNum = refBlockNum;
    }

    public UInteger getRefBlockPrefix() {
        return this.refBlockPrefix;
    }

    public void setRefBlockPrefix(UInteger refBlockPrefix) {
        this.refBlockPrefix = refBlockPrefix;
    }

    public void setRefBlockPrefix(String refBlockPrefix) {
        this.refBlockPrefix = UInteger.valueOf((long)CryptoUtils.readUint32((byte[])CryptoUtils.HEX.decode((CharSequence)refBlockPrefix), (int)4));
    }

    public TimePointSec getExpirationDate() {
        if (this.expirationDate == null || this.expirationDate.getDateTimeAsTimestamp() == 0L) {
            LOGGER.debug("No expiration date has been provided so the latest possible time is used.");
            return new TimePointSec(System.currentTimeMillis() + BeowulfJConfig.getInstance().getMaximumExpirationDateOffset() - 60000L);
        }
        return this.expirationDate;
    }

    public void setExpirationDate(TimePointSec expirationDate) {
        this.expirationDate = expirationDate;
    }

    protected Map<SignatureObject, PrivateKeyType> getRequiredAuthorities() {
        HashMap<SignatureObject, PrivateKeyType> requiredAuthorities = new HashMap<SignatureObject, PrivateKeyType>();
        for (Operation operation : this.getOperations()) {
            requiredAuthorities.putAll(operation.getRequiredAuthorities(requiredAuthorities));
        }
        return requiredAuthorities;
    }

    public Long getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(Long createdTime) {
        if (createdTime == null) {
            createdTime = System.currentTimeMillis() / 1000L;
        }
        this.createdTime = createdTime;
    }

    public void validate() throws BeowulfInvalidTransactionException {
        if (this.getExpirationDate().getDateTimeAsTimestamp() > new Timestamp(System.currentTimeMillis()).getTime() + BeowulfJConfig.getInstance().getMaximumExpirationDateOffset()) {
            LOGGER.warn("The configured expiration date for this transaction is to far in the future and may not be accepted by the Beowulf node.");
        } else if (this.getExpirationDate().getDateTimeAsTimestamp() < new Timestamp(System.currentTimeMillis()).getTime()) {
            throw new BeowulfInvalidTransactionException("The expiration date can't be in the past.");
        }
        boolean isOwnerKeyRequired = false;
        for (Map.Entry<SignatureObject, PrivateKeyType> requiredAuthorities : this.getRequiredAuthorities().entrySet()) {
            PrivateKeyType keyType = requiredAuthorities.getValue();
            if (!keyType.equals((Object)PrivateKeyType.OWNER)) continue;
            isOwnerKeyRequired = true;
        }
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

