/*
 * Decompiled with CFR 0.152.
 */
package com.beowulfchain.beowulfj.base.models;

import com.beowulfchain.beowulfj.base.models.BlockHeaderExtensions;
import com.beowulfchain.beowulfj.exceptions.BeowulfInvalidTransactionException;
import com.beowulfchain.beowulfj.util.BeowulfJUtils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.security.InvalidParameterException;
import org.apache.commons.io.output.ByteArrayOutputStream;

@JsonDeserialize
@JsonSerialize
public class Version
extends BlockHeaderExtensions {
    @JsonIgnore
    private int versionNumber;

    public Version(byte majorVersion, byte hardforkVersion, short releaseVersion) {
        this.versionNumber = (0 | majorVersion) << 8;
        this.versionNumber = (this.versionNumber | hardforkVersion) << 16;
        this.versionNumber |= releaseVersion;
    }

    @JsonCreator
    public Version(String versionAsString) {
        if (!versionAsString.contains(".") && !versionAsString.contains("_")) {
            throw new InvalidParameterException("The given version does not contain the expected delemitter '.' or '_'.");
        }
        String[] versionParts = versionAsString.contains(".") ? versionAsString.split("\\.") : versionAsString.split("_");
        if (versionParts.length != 3) {
            throw new InvalidParameterException("The String representation of a version does not contain all 3 required parts (major, hardfork and release number).");
        }
        int major = Integer.parseInt(versionParts[0]);
        int hardfork = Integer.parseInt(versionParts[1]);
        int revision = Integer.parseInt(versionParts[2]);
        if (major > 255) {
            throw new InvalidParameterException("The Major version is out of range.");
        }
        if (hardfork > 255) {
            throw new InvalidParameterException("The Hardfork version is out of range.");
        }
        if (revision > 65535) {
            throw new InvalidParameterException("The Revision version is out of range.");
        }
        this.versionNumber = 0 | major << 24 | hardfork << 16 | revision;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] toByteArray() throws BeowulfInvalidTransactionException {
        try (ByteArrayOutputStream serializedVersion = new ByteArrayOutputStream();){
            serializedVersion.write(BeowulfJUtils.transformIntToByteArray(this.versionNumber));
            byte[] byArray = serializedVersion.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new BeowulfInvalidTransactionException("A problem occured while transforming the version object into a byte array.", e);
        }
    }

    @Override
    @JsonValue
    public String toString() {
        StringBuilder versionToStingBuilder = new StringBuilder();
        versionToStingBuilder.append(this.versionNumber >> 24 & 0xFF);
        versionToStingBuilder.append(".");
        versionToStingBuilder.append(this.versionNumber >> 16 & 0xFF);
        versionToStingBuilder.append(".");
        versionToStingBuilder.append(this.versionNumber & 0xFFFF);
        return versionToStingBuilder.toString();
    }
}

