/*
 * Decompiled with CFR 0.152.
 */
package com.beowulfchain.beowulfj.base.models.deserializer;

import com.beowulfchain.beowulfj.BeowulfJ;
import com.beowulfchain.beowulfj.chain.smt.objects.AssetObject;
import com.beowulfchain.beowulfj.exceptions.BeowulfCommunicationException;
import com.beowulfchain.beowulfj.exceptions.BeowulfResponseException;
import com.beowulfchain.beowulfj.plugins.apis.condenser.models.FindSmtTokenByName;
import com.beowulfchain.beowulfj.protocol.Asset;
import com.beowulfchain.beowulfj.protocol.enums.AssetSymbolType;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Collections;
import org.joou.UInteger;

public class AssetDeserializer
extends JsonDeserializer<Asset> {
    public Asset deserialize(JsonParser jasonParser, DeserializationContext deserializationContext) throws IOException {
        String[] assetFields;
        JsonToken currentToken = jasonParser.currentToken();
        if (JsonToken.START_OBJECT.equals((Object)currentToken)) {
            AssetObject assetObject = (AssetObject)jasonParser.readValueAs(AssetObject.class);
            Asset asset = new Asset(assetObject.getAmount(), assetObject.getName(), UInteger.valueOf((int)assetObject.getPrecision()));
            return asset;
        }
        if (JsonToken.VALUE_STRING.equals((Object)currentToken) && (assetFields = jasonParser.getText().split(" ")).length == 2) {
            AssetSymbolType nativeSymbol = AssetSymbolType.getValue(assetFields[1]);
            if (nativeSymbol != null) {
                return new Asset(new BigDecimal(assetFields[0]), nativeSymbol);
            }
            try {
                FindSmtTokenByName tokenInfo = BeowulfJ.getInstance().findSmtTokenByName(Collections.singletonList(assetFields[1])).get(0);
                UInteger precision = tokenInfo.getLiquid_symbol().getDecimals();
                return new Asset(new BigDecimal(assetFields[0]), assetFields[1], precision);
            }
            catch (BeowulfCommunicationException | BeowulfResponseException e) {
                e.printStackTrace();
            }
        }
        throw new IllegalArgumentException("Found '" + currentToken + "' instead of '" + JsonToken.VALUE_STRING + "'.");
    }
}

