/*
 * Decompiled with CFR 0.152.
 */
package com.beowulfchain.beowulfj.base.models.deserializer;

import com.beowulfchain.beowulfj.communication.CommunicationHandler;
import com.beowulfchain.beowulfj.plugins.apis.account.history.models.AppliedOperation;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;

public class OperationHistoryHashMapDeserializer
extends JsonDeserializer<Map<BigInteger, AppliedOperation>> {
    public Map<BigInteger, AppliedOperation> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        HashMap<BigInteger, AppliedOperation> result = new HashMap<BigInteger, AppliedOperation>();
        ObjectCodec codec = jsonParser.getCodec();
        TreeNode rootNode = codec.readTree(jsonParser);
        if (rootNode.isArray()) {
            for (JsonNode node : (ArrayNode)rootNode) {
                result.put(new BigInteger(node.get(0).asText()), (AppliedOperation)CommunicationHandler.getObjectMapper().treeToValue((TreeNode)node.get(1), AppliedOperation.class));
            }
            return result;
        }
        throw new IllegalArgumentException("JSON Node is not an array.");
    }
}

