/*
 * Decompiled with CFR 0.152.
 */
package com.beowulfchain.beowulfj.chain;

import com.beowulfchain.beowulfj.base.models.BlockId;
import com.beowulfchain.beowulfj.base.models.FutureExtensions;
import com.beowulfchain.beowulfj.base.models.Transaction;
import com.beowulfchain.beowulfj.configuration.BeowulfJConfig;
import com.beowulfchain.beowulfj.enums.PrivateKeyType;
import com.beowulfchain.beowulfj.enums.ValidationType;
import com.beowulfchain.beowulfj.exceptions.BeowulfInvalidTransactionException;
import com.beowulfchain.beowulfj.fc.TimePointSec;
import com.beowulfchain.beowulfj.interfaces.ByteTransformable;
import com.beowulfchain.beowulfj.interfaces.SignatureObject;
import com.beowulfchain.beowulfj.protocol.AccountName;
import com.beowulfchain.beowulfj.protocol.Authority;
import com.beowulfchain.beowulfj.protocol.TransactionId;
import com.beowulfchain.beowulfj.protocol.operations.Operation;
import com.beowulfchain.beowulfj.util.BeowulfJUtils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import eu.bittrade.crypto.core.CryptoUtils;
import eu.bittrade.crypto.core.ECKey;
import eu.bittrade.crypto.core.Sha256Hash;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.joou.UInteger;
import org.joou.UShort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongycastle.util.encoders.Base64;

public class SignedTransaction
extends Transaction
implements ByteTransformable,
Serializable {
    private static final long serialVersionUID = 4821422578657270330L;
    private static final Logger LOGGER = LoggerFactory.getLogger(SignedTransaction.class);
    protected transient List<String> signatures;

    @JsonCreator
    SignedTransaction(@JsonProperty(value="ref_block_num") UShort refBlockNum, @JsonProperty(value="ref_block_prefix") UInteger refBlockPrefix, @JsonProperty(value="expiration") TimePointSec expirationDate, @JsonProperty(value="operations") List<Operation> operations, @JsonProperty(value="extensions") List<FutureExtensions> extensions, @JsonProperty(value="signatures") List<String> signatures, @JsonProperty(value="created_time") Long createdTime) {
        super(refBlockNum, refBlockPrefix, expirationDate, operations, extensions, createdTime);
        this.signatures = signatures;
    }

    public SignedTransaction(UShort refBlockNum, UInteger refBlockPrefix, TimePointSec expirationDate, List<Operation> operations, List<FutureExtensions> extensions, Long createdTime) {
        super(refBlockNum, refBlockPrefix, expirationDate, operations, extensions, createdTime);
        this.signatures = new ArrayList<String>();
    }

    public SignedTransaction(BlockId blockId, List<Operation> operations, List<FutureExtensions> extensions) {
        super(blockId, operations, extensions);
        this.signatures = new ArrayList<String>();
    }

    @JsonProperty(value="signatures")
    public List<String> getSignatures() {
        return this.signatures;
    }

    @Deprecated
    private boolean isCanonical(byte[] signature) {
        return (signature[0] & 0x80) != 0 || signature[0] == 0 || (signature[1] & 0x80) != 0 || (signature[32] & 0x80) != 0 || signature[32] == 0 || (signature[33] & 0x80) != 0;
    }

    public void sign() throws BeowulfInvalidTransactionException {
        this.sign(BeowulfJConfig.getInstance().getChainId());
    }

    public void sign(String chainId) throws BeowulfInvalidTransactionException {
        if (!BeowulfJConfig.getInstance().getValidationLevel().equals((Object)ValidationType.SKIP_VALIDATION)) {
            this.validate();
        }
        for (ECKey requiredPrivateKey : this.getRequiredSignatureKeys()) {
            Sha256Hash messageAsHash;
            try {
                messageAsHash = Sha256Hash.of((byte[])this.toByteArray(chainId));
            }
            catch (BeowulfInvalidTransactionException e) {
                throw new BeowulfInvalidTransactionException("The required encoding is not supported by your platform.", e);
            }
            String signature = requiredPrivateKey.signMessage(messageAsHash);
            byte[] signatureAsByteArray = Base64.decode((String)signature);
            this.signatures.add(CryptoUtils.HEX.encode(signatureAsByteArray));
        }
    }

    @JsonIgnore
    protected List<ECKey> getRequiredSignatureKeys() throws BeowulfInvalidTransactionException {
        List<ECKey> requiredSignatures = new ArrayList<ECKey>();
        Map<SignatureObject, PrivateKeyType> requiredAuthorities = this.getRequiredAuthorities();
        for (Map.Entry<SignatureObject, PrivateKeyType> requiredAuthority : requiredAuthorities.entrySet()) {
            if (requiredAuthority.getKey() instanceof AccountName) {
                requiredSignatures = this.getRequiredSignatureKeyForAccount(requiredSignatures, (AccountName)requiredAuthority.getKey(), requiredAuthority.getValue());
                continue;
            }
            if (requiredAuthority.getKey() instanceof Authority) continue;
            LOGGER.warn("Unknown SigningObject type {}", (Object)requiredAuthority.getKey());
        }
        return requiredSignatures;
    }

    private List<ECKey> getRequiredSignatureKeyForAccount(List<ECKey> requiredSignatures, AccountName accountName, PrivateKeyType privateKeyType) throws BeowulfInvalidTransactionException {
        ECKey privateKey;
        try {
            privateKey = BeowulfJConfig.getInstance().getPrivateKeyStorage().getKeyForAccount(privateKeyType, accountName);
        }
        catch (InvalidParameterException ipe) {
            throw new BeowulfInvalidTransactionException("Could not find private " + (Object)((Object)privateKeyType) + " key for the user " + accountName.getName() + ".");
        }
        if (!requiredSignatures.contains(privateKey)) {
            requiredSignatures.add(privateKey);
        }
        return requiredSignatures;
    }

    @Override
    public byte[] toByteArray() throws BeowulfInvalidTransactionException {
        return this.toByteArray(BeowulfJConfig.getInstance().getChainId());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected byte[] toByteArray(String chainId) throws BeowulfInvalidTransactionException {
        try (ByteArrayOutputStream serializedTransaction = new ByteArrayOutputStream();){
            if (chainId != null && !chainId.isEmpty()) {
                serializedTransaction.write(CryptoUtils.HEX.decode((CharSequence)chainId));
            }
            serializedTransaction.write(this.serialize());
            byte[] byArray = serializedTransaction.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new BeowulfInvalidTransactionException("A problem occured while transforming the transaction into a byte array.", e);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TransactionId generateTransactionId() throws BeowulfInvalidTransactionException {
        try (ByteArrayOutputStream serializedTransaction = new ByteArrayOutputStream();){
            serializedTransaction.write(this.serialize());
            Sha256Hash messageAsHash = Sha256Hash.of((byte[])serializedTransaction.toByteArray());
            TransactionId transactionId = new TransactionId(messageAsHash.toString().substring(0, 40));
            return transactionId;
        }
        catch (IOException e) {
            throw new BeowulfInvalidTransactionException("A problem occured while transforming the transaction into a byte array.", e);
        }
    }

    private byte[] serialize() throws IOException, BeowulfInvalidTransactionException {
        ByteArrayOutputStream serializedTransaction = new ByteArrayOutputStream();
        serializedTransaction.write(BeowulfJUtils.transformShortToByteArray(this.getRefBlockNum().shortValue()));
        serializedTransaction.write(BeowulfJUtils.transformIntToByteArray(this.getRefBlockPrefix().intValue()));
        serializedTransaction.write(this.getExpirationDate().toByteArray());
        serializedTransaction.write(BeowulfJUtils.transformLongToVarIntByteArray(this.getOperations().size()));
        for (Operation operation : this.getOperations()) {
            operation.validate(BeowulfJConfig.getInstance().getValidationLevel());
            serializedTransaction.write(operation.toByteArray());
        }
        serializedTransaction.write(BeowulfJUtils.transformIntToVarIntByteArray(this.getExtensions().size()));
        for (FutureExtensions futureExtensions : this.getExtensions()) {
            serializedTransaction.write(futureExtensions.toByteArray());
        }
        serializedTransaction.write(BeowulfJUtils.transformLongToByteArray(this.getCreatedTime()));
        return serializedTransaction.toByteArray();
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

