/*
 * Decompiled with CFR 0.152.
 */
package com.beowulfchain.beowulfj.chain.smt.objects;

import java.math.BigDecimal;
import java.security.InvalidParameterException;

public class SmtTokenObject {
    private long amount;
    private int precision;
    private String name;

    public SmtTokenObject(BigDecimal amount, String name, int precision) {
        this.setName(name);
        this.setPrecision(precision);
        this.setAmount(amount);
    }

    public SmtTokenObject(BigDecimal amount, String name) {
        this.setName(name);
        this.setAmount(amount);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        if (amount.scale() > this.getPrecision()) {
            throw new InvalidParameterException("The provided 'amount' has a 'scale' of " + amount.scale() + ", but needs to have a 'scale' of " + this.getPrecision() + " when " + this.getName() + " is used as a AssetSymbolType.");
        }
        this.amount = amount.multiply(BigDecimal.valueOf(Math.pow(10.0, this.getPrecision()))).longValue();
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }
}

