/*
 * Decompiled with CFR 0.152.
 */
package com.beowulfchain.beowulfj.communication;

import com.beowulfchain.beowulfj.base.models.serializer.BooleanSerializer;
import com.beowulfchain.beowulfj.communication.AbstractClient;
import com.beowulfchain.beowulfj.communication.HttpClient;
import com.beowulfchain.beowulfj.communication.WebsocketClient;
import com.beowulfchain.beowulfj.communication.jrpc.JsonRPCRequest;
import com.beowulfchain.beowulfj.communication.jrpc.JsonRPCResponse;
import com.beowulfchain.beowulfj.configuration.BeowulfJConfig;
import com.beowulfchain.beowulfj.exceptions.BeowulfCommunicationException;
import com.beowulfchain.beowulfj.exceptions.BeowulfResponseException;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.io.IOException;
import java.net.URI;
import java.security.InvalidParameterException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.TimeZone;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommunicationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommunicationHandler.class);
    private static ObjectMapper mapper = CommunicationHandler.getObjectMapper();
    private int numberOfConnectionTries = 0;
    private AbstractClient client;

    public CommunicationHandler() throws BeowulfCommunicationException {
        BeowulfJConfig config = BeowulfJConfig.getInstance();
        this.initializeNewClient(config);
    }

    public CommunicationHandler(BeowulfJConfig config) throws BeowulfCommunicationException {
        this.initializeNewClient(config);
    }

    public static ObjectMapper getObjectMapper() {
        if (mapper == null) {
            mapper = new ObjectMapper();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(BeowulfJConfig.getInstance().getDateTimePattern());
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone(BeowulfJConfig.getInstance().getTimeZoneId()));
            mapper.setDateFormat((DateFormat)simpleDateFormat);
            mapper.setTimeZone(TimeZone.getTimeZone(BeowulfJConfig.getInstance().getTimeZoneId()));
            mapper.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
            SimpleModule simpleModule = new SimpleModule("BooleanAsString", new Version(1, 0, 0, null, null, null));
            simpleModule.addSerializer(Boolean.class, (JsonSerializer)new BooleanSerializer());
            simpleModule.addSerializer(Boolean.TYPE, (JsonSerializer)new BooleanSerializer());
            mapper.registerModule((Module)simpleModule);
        }
        return mapper;
    }

    public void initializeNewClient(BeowulfJConfig config) throws BeowulfCommunicationException {
        Pair<URI, Boolean> endpoint;
        if (this.client != null) {
            try {
                this.client.closeConnection();
            }
            catch (IOException e) {
                throw new BeowulfCommunicationException("Could not close the current client connection.", e);
            }
        }
        if (((URI)(endpoint = config.getNextEndpointURI(this.numberOfConnectionTries)).getLeft()).getScheme().toLowerCase().matches("(http){1}[s]?")) {
            this.client = new HttpClient();
        } else if (((URI)endpoint.getLeft()).getScheme().toLowerCase().matches("(ws){1}[s]?")) {
            this.client = new WebsocketClient();
        } else {
            throw new InvalidParameterException("No client implementation for the following protocol available: " + ((URI)endpoint.getLeft()).getScheme().toLowerCase());
        }
    }

    public <T> List<T> performRequest(JsonRPCRequest requestObject, Class<T> targetClass) throws BeowulfCommunicationException, BeowulfResponseException {
        try {
            Pair<URI, Boolean> endpoint = BeowulfJConfig.getInstance().getNextEndpointURI(this.numberOfConnectionTries++);
            JsonRPCResponse rawJsonResponse = this.client.invokeAndReadResponse(requestObject, (URI)endpoint.getLeft(), (Boolean)endpoint.getRight());
            LOGGER.debug("Received {} ", (Object)rawJsonResponse);
            if (rawJsonResponse.isError()) {
                throw rawJsonResponse.handleError(requestObject.getId());
            }
            CollectionType expectedResultType = mapper.getTypeFactory().constructCollectionType(List.class, targetClass);
            return rawJsonResponse.handleResult((JavaType)expectedResultType, requestObject.getId());
        }
        catch (BeowulfCommunicationException e) {
            LOGGER.warn("The connection has been closed. Switching the endpoint and reconnecting.");
            LOGGER.debug("For the following reason: ", (Throwable)e);
            return this.performRequest(requestObject, targetClass);
        }
    }
}

