/*
 * Decompiled with CFR 0.152.
 */
package com.beowulfchain.beowulfj.communication;

import com.beowulfchain.beowulfj.communication.AbstractClient;
import com.beowulfchain.beowulfj.communication.CommunicationHandler;
import com.beowulfchain.beowulfj.communication.HttpClientRequestInitializer;
import com.beowulfchain.beowulfj.communication.jrpc.JsonRPCRequest;
import com.beowulfchain.beowulfj.communication.jrpc.JsonRPCResponse;
import com.beowulfchain.beowulfj.exceptions.BeowulfCommunicationException;
import com.google.api.client.http.ByteArrayContent;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.javanet.NetHttpTransport;
import java.io.IOException;
import java.net.URI;
import java.security.GeneralSecurityException;
import org.apache.http.client.ClientProtocolException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClient
extends AbstractClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpClient.class);

    @Override
    public JsonRPCResponse invokeAndReadResponse(JsonRPCRequest requestObject, URI endpointUri, boolean sslVerificationDisabled) throws BeowulfCommunicationException {
        try {
            NetHttpTransport.Builder builder = new NetHttpTransport.Builder();
            if (sslVerificationDisabled && endpointUri.getScheme().equals("https")) {
                builder.doNotValidateCertificate();
            }
            String requestPayload = requestObject.toJson();
            HttpRequest httpRequest = builder.build().createRequestFactory((HttpRequestInitializer)new HttpClientRequestInitializer()).buildPostRequest(new GenericUrl(endpointUri), (HttpContent)ByteArrayContent.fromString((String)"application/json", (String)requestPayload));
            LOGGER.debug("Sending {}.", (Object)requestPayload);
            HttpResponse httpResponse = httpRequest.execute();
            int status = httpResponse.getStatusCode();
            String responsePayload = httpResponse.parseAsString();
            if (status >= 200 && status < 300 && responsePayload != null) {
                return new JsonRPCResponse(CommunicationHandler.getObjectMapper().readTree(responsePayload));
            }
            throw new ClientProtocolException("Unexpected response status: " + status);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new BeowulfCommunicationException("A problem occured while processing the request.", e);
        }
    }

    @Override
    public void closeConnection() {
    }
}

