/*
 * Decompiled with CFR 0.152.
 */
package com.beowulfchain.beowulfj.communication;

import com.beowulfchain.beowulfj.communication.AbstractClient;
import com.beowulfchain.beowulfj.communication.WebsocketEndpoint;
import com.beowulfchain.beowulfj.communication.WebsocketReconnectHandler;
import com.beowulfchain.beowulfj.communication.jrpc.JsonRPCRequest;
import com.beowulfchain.beowulfj.communication.jrpc.JsonRPCResponse;
import com.beowulfchain.beowulfj.configuration.BeowulfJConfig;
import com.beowulfchain.beowulfj.exceptions.BeowulfCommunicationException;
import com.beowulfchain.beowulfj.exceptions.BeowulfResponseException;
import com.beowulfchain.beowulfj.exceptions.BeowulfTimeoutException;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import javax.websocket.DeploymentException;
import javax.websocket.EncodeException;
import javax.websocket.Endpoint;
import javax.websocket.Session;
import org.glassfish.tyrus.client.ClientManager;
import org.glassfish.tyrus.client.SslContextConfigurator;
import org.glassfish.tyrus.client.SslEngineConfigurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebsocketClient
extends AbstractClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebsocketClient.class);
    private ClientManager client = ClientManager.createClient();
    private CountDownLatch responseCountDownLatch;
    private Session session;
    private WebsocketEndpoint websocketEndpoint;
    private URI currentEndpointUri;

    public WebsocketClient() {
        this.client.setDefaultMaxSessionIdleTimeout((long)BeowulfJConfig.getInstance().getIdleTimeout());
        this.client.getProperties().put("org.glassfish.tyrus.client.ClientManager.ReconnectHandler", new WebsocketReconnectHandler());
        this.websocketEndpoint = new WebsocketEndpoint(this);
        this.responseCountDownLatch = new CountDownLatch(1);
    }

    @Override
    public JsonRPCResponse invokeAndReadResponse(JsonRPCRequest requestObject, URI endpointUri, boolean sslVerificationDisabled) throws BeowulfCommunicationException, BeowulfResponseException {
        if (this.session == null || !this.session.isOpen() || this.currentEndpointUri == null || !this.currentEndpointUri.equals(endpointUri)) {
            this.connect(endpointUri, sslVerificationDisabled);
            this.currentEndpointUri = endpointUri;
        }
        this.responseCountDownLatch = new CountDownLatch(1);
        try {
            String request = requestObject.toJson();
            LOGGER.debug("Sending {}.", (Object)request);
            this.session.getBasicRemote().sendObject((Object)request);
        }
        catch (IOException | EncodeException e) {
            throw new BeowulfCommunicationException("Could not transfer the data to the Beowulf Node. - Reconnecting.", e);
        }
        try {
            do {
                if (BeowulfJConfig.getInstance().getResponseTimeout() == 0) {
                    this.responseCountDownLatch.await();
                    continue;
                }
                if (this.responseCountDownLatch.await(BeowulfJConfig.getInstance().getResponseTimeout(), TimeUnit.MILLISECONDS)) continue;
                throw new BeowulfTimeoutException("Timeout occured. The WebSocket server was not able to answer in " + BeowulfJConfig.getInstance().getResponseTimeout() + " millisecond(s).");
            } while (this.websocketEndpoint.getLatestResponse() == null);
        }
        catch (InterruptedException e) {
            LOGGER.warn("Thread has been interrupted.", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        return this.websocketEndpoint.getLatestResponse();
    }

    @Override
    public void closeConnection() throws IOException {
        if (this.session != null && this.session.isOpen()) {
            LOGGER.debug("Closing existing session.");
            this.session.close();
        }
    }

    protected CountDownLatch getResponseCountDownLatch() {
        return this.responseCountDownLatch;
    }

    protected Session getSession() {
        return this.session;
    }

    protected void setSession(Session session) {
        this.session = session;
    }

    private synchronized void connect(URI endpointURI, boolean sslVerificationDisabled) throws BeowulfCommunicationException {
        if (sslVerificationDisabled && endpointURI.getScheme().equals("wss")) {
            SslEngineConfigurator sslEngineConfigurator = new SslEngineConfigurator(new SslContextConfigurator());
            sslEngineConfigurator.setHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String host, SSLSession sslSession) {
                    return true;
                }
            });
            this.client.getProperties().put("org.glassfish.tyrus.client.sslEngineConfigurator", sslEngineConfigurator);
        }
        try {
            this.closeConnection();
            LOGGER.info("Connecting to {}.", (Object)endpointURI);
            this.session = this.client.connectToServer((Endpoint)this.websocketEndpoint, BeowulfJConfig.getInstance().getClientEndpointConfig(), endpointURI);
        }
        catch (IOException | DeploymentException e) {
            throw new BeowulfCommunicationException("Could not connect to the node - Trying to reconnect.", e);
        }
    }
}

