/*
 * Decompiled with CFR 0.152.
 */
package com.beowulfchain.beowulfj.communication;

import com.beowulfchain.beowulfj.communication.CommunicationHandler;
import com.beowulfchain.beowulfj.communication.WebsocketClient;
import com.beowulfchain.beowulfj.communication.jrpc.JsonRPCResponse;
import com.beowulfchain.beowulfj.exceptions.BeowulfResponseException;
import java.io.IOException;
import javax.websocket.CloseReason;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.MessageHandler;
import javax.websocket.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebsocketEndpoint
extends Endpoint
implements MessageHandler.Whole<String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebsocketEndpoint.class);
    private String latestResponse;
    private WebsocketClient websocketClient;

    public WebsocketEndpoint(WebsocketClient websocketClient) {
        this.websocketClient = websocketClient;
    }

    protected JsonRPCResponse getLatestResponse() throws BeowulfResponseException {
        try {
            if (this.latestResponse != null) {
                return new JsonRPCResponse(CommunicationHandler.getObjectMapper().readTree(this.latestResponse));
            }
            return null;
        }
        catch (IOException e) {
            throw new BeowulfResponseException("Unable to parse the response.", e);
        }
    }

    public void onClose(Session session, CloseReason closeReason) {
        LOGGER.info("Connection has been closed (Code: {}, Reason: {}).", (Object)closeReason.getCloseCode(), (Object)closeReason.getReasonPhrase());
    }

    public void onError(Session session, Throwable thr) {
        LOGGER.error("Connection error.", thr);
    }

    public void onOpen(Session session, EndpointConfig config) {
        this.websocketClient.setSession(session);
        this.websocketClient.getSession().addMessageHandler((MessageHandler)this);
        LOGGER.info("Connection has been established.");
    }

    public void onMessage(String message) {
        this.latestResponse = message;
        if (this.websocketClient.getResponseCountDownLatch().getCount() > 0L) {
            this.websocketClient.getResponseCountDownLatch().countDown();
        } else {
            LOGGER.error("Received an unexpected message.");
        }
    }
}

