/*
 * Decompiled with CFR 0.152.
 */
package com.beowulfchain.beowulfj.communication;

import com.beowulfchain.beowulfj.configuration.BeowulfJConfig;
import javax.websocket.CloseReason;
import org.glassfish.tyrus.client.ClientManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebsocketReconnectHandler
extends ClientManager.ReconnectHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebsocketReconnectHandler.class);

    public boolean onDisconnect(CloseReason closeReason) {
        LOGGER.debug("The connection has been closed (Code: {}, Reason: {}).", (Object)closeReason.getCloseCode(), (Object)closeReason.getReasonPhrase());
        if (BeowulfJConfig.getInstance().getIdleTimeout() <= 0) {
            LOGGER.info("The connection has been closed, but BeowulfJ is configured to never close the conenction. Initiating reconnect.");
            return true;
        }
        return false;
    }

    public boolean onConnectFailure(Exception exception) {
        LOGGER.info("The connection has been closed due to a failure.");
        LOGGER.debug("Reason: ", (Throwable)exception);
        return false;
    }

    public long getDelay() {
        return 0L;
    }
}

