/*
 * Decompiled with CFR 0.152.
 */
package com.beowulfchain.beowulfj.communication.jrpc;

import com.beowulfchain.beowulfj.communication.CommunicationHandler;
import com.beowulfchain.beowulfj.enums.BeowulfApiType;
import com.beowulfchain.beowulfj.enums.RequestMethod;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Random;
import javax.annotation.Nullable;
import org.apache.commons.lang3.builder.ToStringBuilder;

@JsonPropertyOrder(value={"jsonrpc", "method", "params", "id"})
public class JsonRPCRequest {
    private static final String JSONRPC = "2.0";
    private static Random randomGenerator = new Random();
    private final long id = randomGenerator.nextLong();
    private String method;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Object params;

    public JsonRPCRequest(@Nullable BeowulfApiType beowulfApiType, RequestMethod requestMethod, @Nullable Object params) {
        String namespaceAndMethod = "";
        if (beowulfApiType != null) {
            namespaceAndMethod = beowulfApiType.name().toLowerCase() + ".";
        }
        this.method = namespaceAndMethod + requestMethod.name().toLowerCase();
        this.params = params;
    }

    public String getJsonrpc() {
        return JSONRPC;
    }

    public long getId() {
        return this.id;
    }

    public String getMethod() {
        return this.method;
    }

    public Object getParams() {
        return this.params;
    }

    public String toJson() throws JsonProcessingException {
        return CommunicationHandler.getObjectMapper().writeValueAsString((Object)this);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

