/*
 * Decompiled with CFR 0.152.
 */
package com.beowulfchain.beowulfj.communication.jrpc;

import com.beowulfchain.beowulfj.communication.CommunicationHandler;
import com.beowulfchain.beowulfj.exceptions.BeowulfCommunicationException;
import com.beowulfchain.beowulfj.exceptions.BeowulfResponseException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonRPCResponse {
    public static final String ERROR_FIELD_NAME = "error";
    public static final String ERROR_CODE_FIELD_NAME = "code";
    public static final String ERROR_MESSAGE_FIELD_NAME = "message";
    public static final String ERROR_DATA_FIELD_NAME = "data";
    public static final String METHOD_FIELD_NAME = "method";
    public static final String PARAMETERS_FIELD_NAME = "params";
    public static final String ID_FIELD_NAME = "id";
    public static final String RESULT_FIELD_NAME = "result";
    public static final String CALLBACK_METHOD_NAME = "notice";
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonRPCResponse.class);
    private JsonNode rawJsonResponse;

    public JsonRPCResponse(JsonNode rawJsonResponse) {
        this.rawJsonResponse = rawJsonResponse;
    }

    public JsonNode getRawJsonResponse() {
        return this.rawJsonResponse;
    }

    private boolean hasExpectedId(long id, ObjectNode response) {
        return response.has(ID_FIELD_NAME) && response.get(ID_FIELD_NAME) != null && response.get(ID_FIELD_NAME).asLong() == id;
    }

    private boolean isResult() {
        return this.rawJsonResponse.has(RESULT_FIELD_NAME);
    }

    private boolean isResultEmpty() {
        ObjectNode responseAsObject = (ObjectNode)ObjectNode.class.cast(this.rawJsonResponse);
        if (!this.isFieldNullOrEmpty(RESULT_FIELD_NAME, responseAsObject)) {
            return false;
        }
        LOGGER.debug("The response is empty.");
        return true;
    }

    private boolean isResponseValid() {
        if (this.rawJsonResponse.isObject()) {
            return true;
        }
        LOGGER.error("The response is not an object.");
        return false;
    }

    public <T> List<T> handleResult(JavaType type, long id) throws BeowulfCommunicationException {
        if (this.isResponseValid()) {
            if (!this.isResult()) {
                throw new BeowulfCommunicationException("The result does not contain the required result field.");
            }
            ObjectNode responseAsObject = (ObjectNode)ObjectNode.class.cast(this.rawJsonResponse);
            if (!this.hasExpectedId(id, responseAsObject)) {
                throw new BeowulfCommunicationException("The id of this response does not match the expected id. This can cause an unexpected behavior.");
            }
            if (!this.isResultEmpty()) {
                return (List)CommunicationHandler.getObjectMapper().convertValue((Object)responseAsObject.get(RESULT_FIELD_NAME), type);
            }
        }
        return new ArrayList();
    }

    public boolean isError() {
        return this.rawJsonResponse.has(ERROR_FIELD_NAME) && this.rawJsonResponse.get(ERROR_FIELD_NAME) != null && !this.rawJsonResponse.get(ERROR_FIELD_NAME).isNull();
    }

    public BeowulfResponseException handleError(long id) throws BeowulfCommunicationException {
        if (this.isResponseValid()) {
            if (!this.isError()) {
                throw new BeowulfCommunicationException("The result does not contain the required error field.");
            }
            ObjectNode responseAsObject = (ObjectNode)ObjectNode.class.cast(this.rawJsonResponse);
            if (!this.hasExpectedId(id, responseAsObject)) {
                throw new BeowulfCommunicationException("The id of this response does not match the expected id. This can cause an unexpected behavior.");
            }
            return this.createThrowable(responseAsObject);
        }
        throw new BeowulfCommunicationException("Tried to generate a throwable out of a unexpected Json structure.");
    }

    private BeowulfResponseException createThrowable(ObjectNode response) throws BeowulfCommunicationException {
        JsonNode errorNode = response.get(ERROR_FIELD_NAME);
        if (!errorNode.isObject()) {
            throw new BeowulfCommunicationException("The response does not have the expected structure.");
        }
        ObjectNode errorObject = (ObjectNode)ObjectNode.class.cast(errorNode);
        Integer errorCode = this.isFieldNullOrEmpty(ERROR_CODE_FIELD_NAME, errorObject) ? null : Integer.valueOf(errorObject.get(ERROR_CODE_FIELD_NAME).asInt());
        String message = this.isFieldNullOrEmpty(ERROR_MESSAGE_FIELD_NAME, errorObject) ? null : errorObject.get(ERROR_MESSAGE_FIELD_NAME).asText();
        JsonNode data = this.isFieldNullOrEmpty(ERROR_DATA_FIELD_NAME, errorObject) ? null : errorObject.get(ERROR_DATA_FIELD_NAME);
        return new BeowulfResponseException(errorCode, message, data);
    }

    public boolean isFieldNullOrEmpty(String fieldName, ObjectNode response) {
        return response.get(fieldName) == null || response.get(fieldName).isNull();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

