/*
 * Decompiled with CFR 0.152.
 */
package com.beowulfchain.beowulfj.configuration;

import com.beowulfchain.beowulfj.BeowulfJ;
import com.beowulfchain.beowulfj.chain.NetworkProperties;
import com.beowulfchain.beowulfj.chain.network.Testnet;
import com.beowulfchain.beowulfj.configuration.PrivateKeyStorage;
import com.beowulfchain.beowulfj.enums.AddressPrefixType;
import com.beowulfchain.beowulfj.enums.PrivateKeyType;
import com.beowulfchain.beowulfj.enums.SynchronizationType;
import com.beowulfchain.beowulfj.enums.ValidationType;
import com.beowulfchain.beowulfj.protocol.AccountName;
import com.beowulfchain.beowulfj.protocol.enums.AssetSymbolType;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import javax.websocket.ClientEndpointConfig;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeowulfJConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(BeowulfJConfig.class);
    private static final AccountName BEOWULFJ_ACCOUNT = new AccountName("");
    private static final String BEOWULFJ_VERSION = BeowulfJ.class.getPackage().getImplementationVersion();
    private static final String BEOWULFJ_NAME = BeowulfJ.class.getPackage().getImplementationTitle();
    private static String DEFAULT_BEOWULF_API_URI = "https://testnet-bw.beowulfchain.com/rpc";
    private static BeowulfJConfig beowulfJConfigInstance;
    private ClientEndpointConfig clientEndpointConfig;
    private List<Pair<URI, Boolean>> endpointURIs;
    private int responseTimeout;
    private int idleTimeout;
    private String dateTimePattern;
    private long maximumExpirationDateOffset;
    private String timeZoneId;
    private AccountName apiUsername;
    private char[] apiPassword;
    private AccountName defaultAccount;
    private PrivateKeyStorage privateKeyStorage;
    private Charset encodingCharset;
    private AddressPrefixType addressPrefix;
    private String chainId;
    private short beowulfJWeight;
    private ValidationType validationLevel;
    private SynchronizationType synchronizationLevel;
    private AssetSymbolType dollarSymbol;
    private AssetSymbolType tokenSymbol;
    private AssetSymbolType vestsSymbol;
    private NetworkProperties network;

    private BeowulfJConfig() {
        this.setClientEndpointConfig(ClientEndpointConfig.Builder.create().build());
        this.setDefaultBeowulfApiUri(DEFAULT_BEOWULF_API_URI);
        this.setResponseTimeout(10000);
        this.setIdleTimeout(60000);
        this.setDateTime("yyyy-MM-dd'T'HH:mm:ss", "GMT");
        this.setApiUsername(new AccountName(System.getProperty("beowulfj.api.username", "")));
        this.setApiPassword(System.getProperty("beowulfj.api.password", "").toCharArray());
        this.setMaximumExpirationDateOffset(3600000L);
        this.setEncodingCharset(StandardCharsets.UTF_8);
        this.setBeowulfJWeight(Short.valueOf("250"));
        this.setValidationLevel(ValidationType.ALL);
        this.setSynchronizationLevel(SynchronizationType.FULL);
        Testnet network = new Testnet();
        this.setNetwork(network);
        this.setDefaultAccount(new AccountName(System.getProperty("beowulfj.default.account", "")));
        this.privateKeyStorage = new PrivateKeyStorage();
        if (!this.defaultAccount.isEmpty()) {
            this.privateKeyStorage.addAccount(this.defaultAccount);
            for (PrivateKeyType privateKeyType : PrivateKeyType.values()) {
                String wifPrivateKey = System.getProperty("beowulfj.default.account." + privateKeyType.name().toLowerCase() + ".key");
                if (wifPrivateKey == null || wifPrivateKey.isEmpty()) continue;
                this.privateKeyStorage.addPrivateKeyToAccount(this.defaultAccount, (ImmutablePair<PrivateKeyType, String>)new ImmutablePair((Object)privateKeyType, (Object)wifPrivateKey));
            }
        }
    }

    public static BeowulfJConfig getInstance() {
        if (beowulfJConfigInstance == null) {
            beowulfJConfigInstance = new BeowulfJConfig();
        }
        return beowulfJConfigInstance;
    }

    public static BeowulfJConfig getNewInstance() {
        beowulfJConfigInstance = new BeowulfJConfig();
        return beowulfJConfigInstance;
    }

    public static AccountName getBeowulfJAccount() {
        return BEOWULFJ_ACCOUNT;
    }

    public static String getBeowulfJVersion() {
        return BEOWULFJ_VERSION;
    }

    public static String getBeowulfJAppName() {
        return BEOWULFJ_NAME;
    }

    public SynchronizationType getSynchronizationLevel() {
        return this.synchronizationLevel;
    }

    public void setSynchronizationLevel(SynchronizationType synchronizationLevel) {
        this.synchronizationLevel = synchronizationLevel;
    }

    public String getDefaultBeowulfApiUri() {
        return DEFAULT_BEOWULF_API_URI;
    }

    public void setDefaultBeowulfApiUri(String apiUri) {
        DEFAULT_BEOWULF_API_URI = apiUri;
        try {
            this.endpointURIs = new ArrayList<Pair<URI, Boolean>>();
            this.addEndpointURI(new URI(DEFAULT_BEOWULF_API_URI));
        }
        catch (URISyntaxException e) {
            LOGGER.error("At least one of the configured default URIs has a Syntax error.", (Throwable)e);
        }
    }

    public char[] getApiPassword() {
        return this.apiPassword;
    }

    public void setApiPassword(char[] apiPassword) {
        this.apiPassword = apiPassword;
    }

    public AccountName getApiUsername() {
        return this.apiUsername;
    }

    public void setApiUsername(AccountName apiUsername) {
        this.apiUsername = apiUsername;
    }

    public AccountName getDefaultAccount() {
        return this.defaultAccount;
    }

    public void setDefaultAccount(AccountName defaultAccount) {
        this.defaultAccount = defaultAccount;
    }

    public String getChainId() {
        return this.chainId;
    }

    public void setChainId(String chainId) {
        this.chainId = chainId;
    }

    public ClientEndpointConfig getClientEndpointConfig() {
        return this.clientEndpointConfig;
    }

    public void setClientEndpointConfig(ClientEndpointConfig clientEndpointConfig) {
        this.clientEndpointConfig = clientEndpointConfig;
    }

    public String getDateTimePattern() {
        return this.dateTimePattern;
    }

    public Charset getEncodingCharset() {
        return this.encodingCharset;
    }

    public void setEncodingCharset(Charset encodingCharset) {
        this.encodingCharset = encodingCharset;
    }

    public long getMaximumExpirationDateOffset() {
        return this.maximumExpirationDateOffset;
    }

    public void setMaximumExpirationDateOffset(long maximumExpirationDateOffset) {
        this.maximumExpirationDateOffset = maximumExpirationDateOffset;
    }

    public PrivateKeyStorage getPrivateKeyStorage() {
        return this.privateKeyStorage;
    }

    public AddressPrefixType getAddressPrefix() {
        return this.addressPrefix;
    }

    public void setAddressPrefix(AddressPrefixType addressPrefix) {
        this.addressPrefix = addressPrefix;
    }

    public int getResponseTimeout() {
        return this.responseTimeout;
    }

    public void setResponseTimeout(int responseTimeout) {
        if (responseTimeout < 0) {
            throw new IllegalArgumentException("The timeout has to be greater than 0. (0 will disable the timeout).");
        }
        this.responseTimeout = responseTimeout;
    }

    public int getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(int idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public String getTimeZoneId() {
        return this.timeZoneId;
    }

    public List<Pair<URI, Boolean>> getEndpointURIs() {
        return this.endpointURIs;
    }

    public void setEndpointURIs(List<Pair<URI, Boolean>> endpointURIs) {
        this.endpointURIs = endpointURIs;
    }

    public Pair<URI, Boolean> getNextEndpointURI(int selector) {
        return this.endpointURIs.get(selector % this.endpointURIs.size());
    }

    public short getBeowulfJWeight() {
        return this.beowulfJWeight;
    }

    public void setBeowulfJWeight(short beowulfJWeight) {
        this.beowulfJWeight = beowulfJWeight;
    }

    public void setDateTime(String dateTimePattern, String timeZoneId) {
        new SimpleDateFormat(dateTimePattern);
        this.dateTimePattern = dateTimePattern;
        if (!"GMT".equals(timeZoneId) && "GMT".equals(TimeZone.getTimeZone(timeZoneId).getID())) {
            LOGGER.warn("The timezoneId {} could not be understood - UTC will now be used as a default.", (Object)timeZoneId);
            this.timeZoneId = "UTC";
        } else {
            this.timeZoneId = timeZoneId;
        }
    }

    public void addEndpointURI(URI endpointURI) throws URISyntaxException {
        this.addEndpointURI(endpointURI, false);
    }

    public void addEndpointURI(URI endpointURI, boolean sslVerificationDisabled) throws URISyntaxException {
        if (endpointURI == null) {
            throw new URISyntaxException("endpointURI", "The endpointURI can't be null.");
        }
        this.endpointURIs.add((Pair<URI, Boolean>)new ImmutablePair((Object)endpointURI, (Object)sslVerificationDisabled));
    }

    public ValidationType getValidationLevel() {
        return this.validationLevel;
    }

    public void setValidationLevel(ValidationType validationLevel) {
        this.validationLevel = validationLevel;
    }

    public AssetSymbolType getDollarSymbol() {
        return this.dollarSymbol;
    }

    public void setDollarSymbol(AssetSymbolType dollarSymbol) {
        this.dollarSymbol = dollarSymbol;
    }

    public AssetSymbolType getTokenSymbol() {
        return this.tokenSymbol;
    }

    public void setTokenSymbol(AssetSymbolType tokenSymbol) {
        this.tokenSymbol = tokenSymbol;
    }

    public AssetSymbolType getVestsSymbol() {
        return this.vestsSymbol;
    }

    public void setVestsSymbol(AssetSymbolType vestsSymbol) {
        this.vestsSymbol = vestsSymbol;
    }

    public NetworkProperties getNetwork() {
        return this.network;
    }

    public void setNetwork(NetworkProperties network) {
        this.network = network;
        this.setAddressPrefix(AddressPrefixType.valueOf(network.getPrefix()));
        this.setChainId(network.getChain_id());
        this.setDollarSymbol(AssetSymbolType.getValue(network.getWd_symbol()));
        this.setTokenSymbol(AssetSymbolType.getValue(network.getBeowulf_symbol()));
        this.setVestsSymbol(AssetSymbolType.getValue(network.getVests_symbol()));
    }
}

