/*
 * Decompiled with CFR 0.152.
 */
package com.beowulfchain.beowulfj.configuration;

import com.beowulfchain.beowulfj.enums.PrivateKeyType;
import com.beowulfchain.beowulfj.protocol.AccountName;
import eu.bittrade.crypto.core.DumpedPrivateKey;
import eu.bittrade.crypto.core.ECKey;
import eu.bittrade.crypto.core.base58.Base58ChecksumProvider;
import eu.bittrade.crypto.core.base58.Sha256ChecksumProvider;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class PrivateKeyStorage {
    private HashMap<AccountName, List<ImmutablePair<PrivateKeyType, ECKey>>> privateKeysPerAccounts = new HashMap();

    public ECKey getKeyForAccount(PrivateKeyType privateKeyType, AccountName accountName) {
        List<ImmutablePair<PrivateKeyType, ECKey>> privateKeysForAccount = this.getPrivateKeysPerAccounts().get(accountName);
        if (privateKeysForAccount == null) {
            throw new InvalidParameterException(privateKeyType.name() + " for the account '" + accountName + "' has not been added to the PrivateKeyStore.");
        }
        for (ImmutablePair<PrivateKeyType, ECKey> privateKey : privateKeysForAccount) {
            if (privateKey == null || !((PrivateKeyType)((Object)privateKey.getLeft())).equals((Object)privateKeyType)) continue;
            return (ECKey)privateKey.getRight();
        }
        throw new InvalidParameterException(privateKeyType.name() + " for the account '" + accountName + "' has not been added to the PrivateKeyStore.");
    }

    public void addAccount(AccountName accountName) {
        this.getPrivateKeysPerAccounts().put(accountName, new ArrayList());
    }

    public void addAccount(AccountName accountName, List<ImmutablePair<PrivateKeyType, String>> privateKeys) {
        this.addAccount(accountName);
        for (ImmutablePair<PrivateKeyType, String> privateKey : privateKeys) {
            this.addPrivateKeyToAccount(accountName, privateKey);
        }
    }

    public void addPrivateKeyToAccount(AccountName accountName, ImmutablePair<PrivateKeyType, String> privateKey) {
        if (this.getPrivateKeysPerAccounts().get(accountName) == null) {
            this.addAccount(accountName);
        }
        this.getPrivateKeysPerAccounts().get(accountName).add(this.convertWifToECKeyPair(privateKey));
    }

    public List<ImmutablePair<PrivateKeyType, ECKey>> removeAccount(AccountName accountName) {
        return this.getPrivateKeysPerAccounts().remove(accountName);
    }

    public Map<AccountName, List<ImmutablePair<PrivateKeyType, ECKey>>> getPrivateKeysPerAccounts() {
        return this.privateKeysPerAccounts;
    }

    public List<AccountName> getAccounts() {
        ArrayList<AccountName> storedAccounts = new ArrayList<AccountName>();
        storedAccounts.addAll(this.getPrivateKeysPerAccounts().keySet());
        return storedAccounts;
    }

    private ImmutablePair<PrivateKeyType, ECKey> convertWifToECKeyPair(ImmutablePair<PrivateKeyType, String> wifPrivateKey) {
        return new ImmutablePair(wifPrivateKey.getLeft(), (Object)DumpedPrivateKey.fromBase58(null, (String)((String)wifPrivateKey.getRight()), (Base58ChecksumProvider)new Sha256ChecksumProvider()).getKey());
    }
}

