/*
 * Decompiled with CFR 0.152.
 */
package com.beowulfchain.beowulfj.fc;

import com.beowulfchain.beowulfj.exceptions.BeowulfInvalidTransactionException;
import com.beowulfchain.beowulfj.interfaces.ByteTransformable;
import com.beowulfchain.beowulfj.util.BeowulfJUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class TimePointSec
implements ByteTransformable {
    @JsonIgnore
    private long dateTime;

    public TimePointSec(@JsonProperty String dateTime) {
        try {
            this.setDateTime(dateTime);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Not able to transform '" + dateTime + "' into a date object.");
        }
    }

    public TimePointSec(long dateTime) {
        this.setDateTime(dateTime);
    }

    @JsonValue
    public String getDateTime() {
        return BeowulfJUtils.transformDateToString(this.getDateTimeAsDate());
    }

    public void setDateTime(String dateTime) throws ParseException {
        this.setDateTime(BeowulfJUtils.transformStringToTimestamp(dateTime));
    }

    @JsonIgnore
    public void setDateTime(long dateTime) {
        this.dateTime = dateTime;
    }

    @JsonIgnore
    public Date getDateTimeAsDate() {
        return new Date(this.dateTime);
    }

    @JsonIgnore
    public int getDateTimeAsInt() {
        return (int)(this.dateTime / 1000L);
    }

    @JsonIgnore
    public long getDateTimeAsTimestamp() {
        return this.dateTime;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] toByteArray() throws BeowulfInvalidTransactionException {
        try (ByteArrayOutputStream serializedDateTime = new ByteArrayOutputStream();){
            serializedDateTime.write(BeowulfJUtils.transformIntToByteArray(this.getDateTimeAsInt()));
            byte[] byArray = serializedDateTime.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new BeowulfInvalidTransactionException("A problem occured while transforming the model into a byte array.", e);
        }
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public boolean equals(Object otherTimePointSec) {
        if (this == otherTimePointSec) {
            return true;
        }
        if (otherTimePointSec == null || !(otherTimePointSec instanceof TimePointSec)) {
            return false;
        }
        TimePointSec other = (TimePointSec)otherTimePointSec;
        return this.getDateTime().equals(other.getDateTime());
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDateTime() == null ? 0 : this.getDateTime().hashCode());
        return hashCode;
    }
}

