/*
 * Decompiled with CFR 0.152.
 */
package com.beowulfchain.beowulfj.plugins.apis.condenser;

import com.beowulfchain.beowulfj.base.models.Account;
import com.beowulfchain.beowulfj.base.models.Block;
import com.beowulfchain.beowulfj.base.models.ScheduledHardfork;
import com.beowulfchain.beowulfj.chain.CompletedTransaction;
import com.beowulfchain.beowulfj.chain.SignedTransaction;
import com.beowulfchain.beowulfj.communication.CommunicationHandler;
import com.beowulfchain.beowulfj.communication.jrpc.JsonRPCRequest;
import com.beowulfchain.beowulfj.enums.BeowulfApiType;
import com.beowulfchain.beowulfj.enums.RequestMethod;
import com.beowulfchain.beowulfj.exceptions.BeowulfCommunicationException;
import com.beowulfchain.beowulfj.exceptions.BeowulfInvalidTransactionException;
import com.beowulfchain.beowulfj.exceptions.BeowulfResponseException;
import com.beowulfchain.beowulfj.plugins.apis.condenser.models.AccountHistoryReturn;
import com.beowulfchain.beowulfj.plugins.apis.condenser.models.ExtendedAccount;
import com.beowulfchain.beowulfj.plugins.apis.condenser.models.ExtendedDynamicGlobalProperties;
import com.beowulfchain.beowulfj.plugins.apis.condenser.models.FindSmtTokenByName;
import com.beowulfchain.beowulfj.plugins.apis.database.models.Config;
import com.beowulfchain.beowulfj.plugins.apis.database.models.Supernode;
import com.beowulfchain.beowulfj.plugins.apis.database.models.SupernodeSchedule;
import com.beowulfchain.beowulfj.plugins.apis.network.broadcast.models.BroadcastTransactionSynchronousReturn;
import com.beowulfchain.beowulfj.protocol.AccountName;
import com.beowulfchain.beowulfj.protocol.Asset;
import com.beowulfchain.beowulfj.protocol.AssetInfo;
import com.beowulfchain.beowulfj.protocol.BlockHeader;
import com.beowulfchain.beowulfj.protocol.PublicKey;
import com.beowulfchain.beowulfj.protocol.SignedBlock;
import com.beowulfchain.beowulfj.protocol.TransactionId;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.joou.UInteger;
import org.joou.ULong;

public class CondenserApi {
    private CondenserApi() {
    }

    public static ExtendedDynamicGlobalProperties getDynamicGlobalProperties(CommunicationHandler communicationHandler) throws BeowulfCommunicationException, BeowulfResponseException {
        JsonRPCRequest requestObject = new JsonRPCRequest(BeowulfApiType.CONDENSER_API, RequestMethod.GET_DYNAMIC_GLOBAL_PROPERTIES, Collections.emptyList());
        return communicationHandler.performRequest(requestObject, ExtendedDynamicGlobalProperties.class).get(0);
    }

    public static List<ExtendedAccount> getExtAccounts(CommunicationHandler communicationHandler, List<AccountName> accounts) throws BeowulfCommunicationException, BeowulfResponseException {
        JsonRPCRequest requestObject = new JsonRPCRequest(BeowulfApiType.CONDENSER_API, RequestMethod.GET_ACCOUNTS, Collections.singletonList(accounts));
        return communicationHandler.performRequest(requestObject, ExtendedAccount.class);
    }

    public static String getHardforkVersion(CommunicationHandler communicationHandler) throws BeowulfCommunicationException, BeowulfResponseException {
        JsonRPCRequest requestObject = new JsonRPCRequest(BeowulfApiType.CONDENSER_API, RequestMethod.GET_HARDFORK_VERSION, Collections.emptyList());
        return communicationHandler.performRequest(requestObject, String.class).get(0);
    }

    public static BlockHeader getBlockHeader(CommunicationHandler communicationHandler, long blockNum) throws BeowulfCommunicationException, BeowulfResponseException {
        JsonRPCRequest requestObject = new JsonRPCRequest(BeowulfApiType.CONDENSER_API, RequestMethod.GET_BLOCK_HEADER, Collections.singletonList(blockNum));
        return communicationHandler.performRequest(requestObject, BlockHeader.class).get(0);
    }

    public static Block getBlock(CommunicationHandler communicationHandler, long blockNum) throws BeowulfCommunicationException, BeowulfResponseException {
        JsonRPCRequest requestObject = new JsonRPCRequest(BeowulfApiType.CONDENSER_API, RequestMethod.GET_BLOCK, Collections.singletonList(blockNum));
        return communicationHandler.performRequest(requestObject, Block.class).get(0);
    }

    public static List<AccountName> getActiveSuperNodes(CommunicationHandler communicationHandler) throws BeowulfCommunicationException, BeowulfResponseException {
        JsonRPCRequest requestObject = new JsonRPCRequest(BeowulfApiType.CONDENSER_API, RequestMethod.GET_ACTIVE_SUPERNODES, Collections.emptyList());
        return communicationHandler.performRequest(requestObject, AccountName.class);
    }

    public static Config getConfig(CommunicationHandler communicationHandler) throws BeowulfCommunicationException, BeowulfResponseException {
        JsonRPCRequest requestObject = new JsonRPCRequest(BeowulfApiType.CONDENSER_API, RequestMethod.GET_CONFIG, Collections.emptyList());
        return communicationHandler.performRequest(requestObject, Config.class).get(0);
    }

    public static List<Account> getAccounts(CommunicationHandler communicationHandler, List<AccountName> accounts) throws BeowulfCommunicationException, BeowulfResponseException {
        JsonRPCRequest requestObject = new JsonRPCRequest(BeowulfApiType.CONDENSER_API, RequestMethod.GET_ACCOUNTS, Collections.singletonList(accounts));
        return communicationHandler.performRequest(requestObject, Account.class);
    }

    @Deprecated
    public static List<AccountHistoryReturn> getAccountHistory(CommunicationHandler communicationHandler, String account, long start, long limit) throws BeowulfCommunicationException, BeowulfResponseException {
        JsonRPCRequest requestObject = new JsonRPCRequest(BeowulfApiType.CONDENSER_API, RequestMethod.GET_ACCOUNT_HISTORY, Arrays.asList(account, start, limit));
        return communicationHandler.performRequest(requestObject, AccountHistoryReturn.class);
    }

    public static String getTransactionHex(CommunicationHandler communicationHandler, SignedTransaction transaction) throws BeowulfCommunicationException, BeowulfResponseException {
        JsonRPCRequest requestObject = new JsonRPCRequest(BeowulfApiType.CONDENSER_API, RequestMethod.GET_TRANSACTION_HEX, Collections.singletonList(transaction));
        return communicationHandler.performRequest(requestObject, String.class).get(0);
    }

    public static List<FindSmtTokenByName> findSmtTokenByName(CommunicationHandler communicationHandler, List<String> names) throws BeowulfCommunicationException, BeowulfResponseException {
        JsonRPCRequest requestObject = new JsonRPCRequest(BeowulfApiType.CONDENSER_API, RequestMethod.FIND_SMT_TOKENS_BY_NAME, Collections.singletonList(names));
        return communicationHandler.performRequest(requestObject, FindSmtTokenByName.class);
    }

    public static ScheduledHardfork getNextScheduleHardfork(CommunicationHandler communicationHandler) throws BeowulfCommunicationException, BeowulfResponseException {
        JsonRPCRequest requestObject = new JsonRPCRequest(BeowulfApiType.CONDENSER_API, RequestMethod.GET_NEXT_SCHEDULED_HARDFORK, Collections.emptyList());
        return communicationHandler.performRequest(requestObject, ScheduledHardfork.class).get(0);
    }

    public static List<String> getKeyReferences(CommunicationHandler communicationHandler, List<PublicKey> publicKeys) throws BeowulfCommunicationException, BeowulfResponseException {
        JsonRPCRequest requestObject = new JsonRPCRequest(BeowulfApiType.CONDENSER_API, RequestMethod.GET_KEY_REFERENCES, Collections.singleton(publicKeys));
        return communicationHandler.performRequest(requestObject, List.class).get(0);
    }

    public static ULong getAccountCount(CommunicationHandler communicationHandler) throws BeowulfCommunicationException, BeowulfResponseException {
        JsonRPCRequest requestObject = new JsonRPCRequest(BeowulfApiType.CONDENSER_API, RequestMethod.GET_ACCOUNT_COUNT, Collections.emptyList());
        return communicationHandler.performRequest(requestObject, ULong.class).get(0);
    }

    public static Supernode getSupernodeByAccount(CommunicationHandler communicationHandler, AccountName supernodeAccount) throws BeowulfCommunicationException, BeowulfResponseException {
        JsonRPCRequest requestObject = new JsonRPCRequest(BeowulfApiType.CONDENSER_API, RequestMethod.GET_SUPERNODE_BY_ACCOUNT, Collections.singleton(supernodeAccount));
        return communicationHandler.performRequest(requestObject, Supernode.class).get(0);
    }

    public static List<Supernode> getSupernodesByVote(CommunicationHandler communicationHandler, AccountName supernodeAccount, int limit, int vestingShare) throws BeowulfCommunicationException, BeowulfResponseException {
        JsonRPCRequest requestObject = new JsonRPCRequest(BeowulfApiType.CONDENSER_API, RequestMethod.GET_SUPERNODES_BY_VOTE, Arrays.asList(supernodeAccount, limit, vestingShare));
        return communicationHandler.performRequest(requestObject, Supernode.class);
    }

    public static SupernodeSchedule getSupernodeSchedule(CommunicationHandler communicationHandler) throws BeowulfCommunicationException, BeowulfResponseException {
        JsonRPCRequest requestObject = new JsonRPCRequest(BeowulfApiType.CONDENSER_API, RequestMethod.GET_SUPERNODE_SCHEDULE, Collections.emptyList());
        return communicationHandler.performRequest(requestObject, SupernodeSchedule.class).get(0);
    }

    public static int getSupernodeCount(CommunicationHandler communicationHandler) throws BeowulfCommunicationException, BeowulfResponseException {
        JsonRPCRequest requestObject = new JsonRPCRequest(BeowulfApiType.CONDENSER_API, RequestMethod.GET_SUPERNODE_COUNT, Collections.emptyList());
        return communicationHandler.performRequest(requestObject, UInteger.class).get(0).intValue();
    }

    public static List<String> lookupSupernodeAccounts(CommunicationHandler communicationHandler, String pattern, int limit) throws BeowulfCommunicationException, BeowulfResponseException {
        JsonRPCRequest requestObject = new JsonRPCRequest(BeowulfApiType.CONDENSER_API, RequestMethod.LOOKUP_SUPERNODE_ACCOUNTS, Arrays.asList(pattern, limit));
        return communicationHandler.performRequest(requestObject, String.class);
    }

    public static List<String> lookupAccounts(CommunicationHandler communicationHandler, String pattern, int limit) throws BeowulfCommunicationException, BeowulfResponseException {
        JsonRPCRequest requestObject = new JsonRPCRequest(BeowulfApiType.CONDENSER_API, RequestMethod.LOOKUP_ACCOUNTS, Arrays.asList(pattern, limit));
        return communicationHandler.performRequest(requestObject, String.class);
    }

    public static CompletedTransaction getTransactionDetail(CommunicationHandler communicationHandler, String trx_id) throws BeowulfCommunicationException, BeowulfResponseException {
        JsonRPCRequest requestObject = new JsonRPCRequest(BeowulfApiType.CONDENSER_API, RequestMethod.GET_TRANSACTION, Collections.singletonList(trx_id));
        return communicationHandler.performRequest(requestObject, CompletedTransaction.class).get(0);
    }

    public static Boolean verifyAccountAuthority(CommunicationHandler communicationHandler, AccountName accountName, List<PublicKey> publicKeys) throws BeowulfCommunicationException, BeowulfResponseException {
        JsonRPCRequest requestObject = new JsonRPCRequest(BeowulfApiType.CONDENSER_API, RequestMethod.VERIFY_ACCOUNT_AUTHORITY, Arrays.asList(accountName, publicKeys));
        return communicationHandler.performRequest(requestObject, Boolean.class).get(0);
    }

    public static Asset getBalance(CommunicationHandler communicationHandler, String accountName, AssetInfo assetInfo) throws BeowulfCommunicationException, BeowulfResponseException {
        JsonRPCRequest requestObject = new JsonRPCRequest(BeowulfApiType.CONDENSER_API, RequestMethod.GET_BALANCE, Arrays.asList(accountName, assetInfo));
        return communicationHandler.performRequest(requestObject, Asset.class).get(0);
    }

    public static void broadcastBlock(CommunicationHandler communicationHandler, SignedBlock signedBlock) throws BeowulfCommunicationException, BeowulfResponseException {
        JsonRPCRequest requestObject = new JsonRPCRequest(BeowulfApiType.CONDENSER_API, RequestMethod.BROADCAST_BLOCK, Collections.singleton(signedBlock));
        communicationHandler.performRequest(requestObject, Object.class);
    }

    public static TransactionId broadcastTransaction(CommunicationHandler communicationHandler, SignedTransaction transaction) throws BeowulfCommunicationException, BeowulfResponseException, BeowulfInvalidTransactionException {
        if (transaction.getSignatures() == null || transaction.getSignatures().isEmpty()) {
            transaction.sign();
        }
        JsonRPCRequest requestObject = new JsonRPCRequest(BeowulfApiType.CONDENSER_API, RequestMethod.BROADCAST_TRANSACTION, Collections.singletonList(transaction));
        communicationHandler.performRequest(requestObject, Object.class);
        return transaction.generateTransactionId();
    }

    public static BroadcastTransactionSynchronousReturn broadcastTransactionSynchronous(CommunicationHandler communicationHandler, SignedTransaction transaction) throws BeowulfCommunicationException, BeowulfResponseException, BeowulfInvalidTransactionException {
        if (transaction.getSignatures() == null || transaction.getSignatures().isEmpty()) {
            transaction.sign();
            System.out.println(transaction.generateTransactionId());
        }
        JsonRPCRequest requestObject = new JsonRPCRequest(BeowulfApiType.CONDENSER_API, RequestMethod.BROADCAST_TRANSACTION_SYNCHRONOUS, Collections.singletonList(transaction));
        return communicationHandler.performRequest(requestObject, BroadcastTransactionSynchronousReturn.class).get(0);
    }
}

