/*
 * Decompiled with CFR 0.152.
 */
package com.beowulfchain.beowulfj.plugins.apis.database;

import com.beowulfchain.beowulfj.communication.CommunicationHandler;
import com.beowulfchain.beowulfj.communication.jrpc.JsonRPCRequest;
import com.beowulfchain.beowulfj.enums.BeowulfApiType;
import com.beowulfchain.beowulfj.enums.RequestMethod;
import com.beowulfchain.beowulfj.exceptions.BeowulfCommunicationException;
import com.beowulfchain.beowulfj.exceptions.BeowulfResponseException;
import com.beowulfchain.beowulfj.plugins.apis.database.models.Config;
import com.beowulfchain.beowulfj.plugins.apis.database.models.DynamicGlobalProperty;
import com.beowulfchain.beowulfj.plugins.apis.database.models.GetPotentialSignaturesArgs;
import com.beowulfchain.beowulfj.plugins.apis.database.models.GetPotentialSignaturesReturn;
import com.beowulfchain.beowulfj.plugins.apis.database.models.GetRequiredSignaturesArgs;
import com.beowulfchain.beowulfj.plugins.apis.database.models.GetRequiredSignaturesReturn;
import com.beowulfchain.beowulfj.plugins.apis.database.models.GetTransactionHexArgs;
import com.beowulfchain.beowulfj.plugins.apis.database.models.GetTransactionHexReturn;
import com.beowulfchain.beowulfj.plugins.apis.database.models.SupernodeSchedule;
import com.beowulfchain.beowulfj.plugins.apis.database.models.VerifyAccountAuthorityArgs;
import com.beowulfchain.beowulfj.plugins.apis.database.models.VerifyAccountAuthorityReturn;
import com.beowulfchain.beowulfj.plugins.apis.database.models.VerifyAuthorityArgs;
import com.beowulfchain.beowulfj.plugins.apis.database.models.VerifyAuthorityReturn;
import com.beowulfchain.beowulfj.protocol.AccountName;
import java.util.List;

public class DatabaseApi {
    private DatabaseApi() {
    }

    public static Config getConfig(CommunicationHandler communicationHandler) throws BeowulfCommunicationException, BeowulfResponseException {
        JsonRPCRequest requestObject = new JsonRPCRequest(BeowulfApiType.DATABASE_API, RequestMethod.GET_CONFIG, null);
        return communicationHandler.performRequest(requestObject, Config.class).get(0);
    }

    public static DynamicGlobalProperty getDynamicGlobalProperties(CommunicationHandler communicationHandler) throws BeowulfCommunicationException, BeowulfResponseException {
        JsonRPCRequest requestObject = new JsonRPCRequest(BeowulfApiType.DATABASE_API, RequestMethod.GET_DYNAMIC_GLOBAL_PROPERTIES, null);
        return communicationHandler.performRequest(requestObject, DynamicGlobalProperty.class).get(0);
    }

    public static SupernodeSchedule getSupernodeSchedule(CommunicationHandler communicationHandler) throws BeowulfCommunicationException, BeowulfResponseException {
        JsonRPCRequest requestObject = new JsonRPCRequest(BeowulfApiType.DATABASE_API, RequestMethod.GET_SUPERNODE_SCHEDULE, null);
        return communicationHandler.performRequest(requestObject, SupernodeSchedule.class).get(0);
    }

    public static List<AccountName> getActiveSupernodes(CommunicationHandler communicationHandler) throws BeowulfCommunicationException, BeowulfResponseException {
        JsonRPCRequest requestObject = new JsonRPCRequest(BeowulfApiType.DATABASE_API, RequestMethod.GET_ACTIVE_SUPERNODES, null);
        return communicationHandler.performRequest(requestObject, AccountName.class);
    }

    public static GetTransactionHexReturn getTransactionHex(CommunicationHandler communicationHandler, GetTransactionHexArgs getTransactionHexArgs) throws BeowulfCommunicationException, BeowulfResponseException {
        JsonRPCRequest requestObject = new JsonRPCRequest(BeowulfApiType.DATABASE_API, RequestMethod.GET_TRANSACTION_HEX, getTransactionHexArgs);
        return communicationHandler.performRequest(requestObject, GetTransactionHexReturn.class).get(0);
    }

    public static GetRequiredSignaturesReturn getRequiredSignatures(CommunicationHandler communicationHandler, GetRequiredSignaturesArgs getRequiredSignaturesArgs) throws BeowulfCommunicationException, BeowulfResponseException {
        JsonRPCRequest requestObject = new JsonRPCRequest(BeowulfApiType.DATABASE_API, RequestMethod.GET_REQUIRED_SIGNATURES, getRequiredSignaturesArgs);
        return communicationHandler.performRequest(requestObject, GetRequiredSignaturesReturn.class).get(0);
    }

    public static GetPotentialSignaturesReturn getPotentialSignatures(CommunicationHandler communicationHandler, GetPotentialSignaturesArgs getPotentialSignaturesArgs) throws BeowulfCommunicationException, BeowulfResponseException {
        JsonRPCRequest requestObject = new JsonRPCRequest(BeowulfApiType.DATABASE_API, RequestMethod.GET_POTENTIAL_SIGNATURES, getPotentialSignaturesArgs);
        return communicationHandler.performRequest(requestObject, GetPotentialSignaturesReturn.class).get(0);
    }

    public static VerifyAuthorityReturn verifyAuthority(CommunicationHandler communicationHandler, VerifyAuthorityArgs verifyAuthorityArgs) throws BeowulfCommunicationException, BeowulfResponseException {
        JsonRPCRequest requestObject = new JsonRPCRequest(BeowulfApiType.DATABASE_API, RequestMethod.VERIFY_AUTHORITY, verifyAuthorityArgs);
        return communicationHandler.performRequest(requestObject, VerifyAuthorityReturn.class).get(0);
    }

    public static VerifyAccountAuthorityReturn verifyAccountAuthority(CommunicationHandler communicationHandler, VerifyAccountAuthorityArgs verifyAccountAuthorityArgs) throws BeowulfCommunicationException, BeowulfResponseException {
        JsonRPCRequest requestObject = new JsonRPCRequest(BeowulfApiType.DATABASE_API, RequestMethod.VERIFY_ACCOUNT_AUTHORITY, null);
        return communicationHandler.performRequest(requestObject, VerifyAccountAuthorityReturn.class).get(0);
    }
}

