/*
 * Decompiled with CFR 0.152.
 */
package com.beowulfchain.beowulfj.protocol;

import com.beowulfchain.beowulfj.exceptions.BeowulfInvalidTransactionException;
import com.beowulfchain.beowulfj.interfaces.ByteTransformable;
import com.beowulfchain.beowulfj.interfaces.SignatureObject;
import com.beowulfchain.beowulfj.util.BeowulfJUtils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.security.InvalidParameterException;

public class AccountName
implements ByteTransformable,
SignatureObject {
    private String name;

    public AccountName() {
        this.setName("");
    }

    @JsonCreator
    public AccountName(String name) {
        this.setName(name);
    }

    @JsonValue
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name == null) {
            this.name = "";
        } else {
            if (!name.isEmpty()) {
                if (name.length() < 3 || name.length() > 16) {
                    throw new InvalidParameterException("An account name needs to have a minimum length of 3 and a maximum length of 16.");
                }
                if (!name.split("\\.")[0].matches("^[a-z]{1}[a-z0-9\\-]{1,14}[a-z0-9]{1}")) {
                    throw new InvalidParameterException("The given account name '" + name + "' contains unsupported characters. The first character needs to be one of 'a-z', characters in the middle can be 'a-z', '0,9' and a '-' and the last character of the name has to be one of 'a-z' and '0-9'.");
                }
            }
            this.name = name;
        }
    }

    @Override
    public byte[] toByteArray() throws BeowulfInvalidTransactionException {
        return BeowulfJUtils.transformStringToVarIntByteArray(this.getName());
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object otherAccount) {
        if (this == otherAccount) {
            return true;
        }
        if (otherAccount == null || !(otherAccount instanceof AccountName)) {
            return false;
        }
        AccountName other = (AccountName)otherAccount;
        return this.getName().equals(other.getName());
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        return hashCode;
    }

    public boolean isEmpty() {
        return this.getName().isEmpty();
    }
}

