/*
 * Decompiled with CFR 0.152.
 */
package com.beowulfchain.beowulfj.protocol;

import com.beowulfchain.beowulfj.BeowulfJ;
import com.beowulfchain.beowulfj.base.models.deserializer.AssetDeserializer;
import com.beowulfchain.beowulfj.base.models.serializer.AssetSerializer;
import com.beowulfchain.beowulfj.configuration.BeowulfJConfig;
import com.beowulfchain.beowulfj.exceptions.BeowulfCommunicationException;
import com.beowulfchain.beowulfj.exceptions.BeowulfInvalidTransactionException;
import com.beowulfchain.beowulfj.exceptions.BeowulfResponseException;
import com.beowulfchain.beowulfj.interfaces.ByteTransformable;
import com.beowulfchain.beowulfj.plugins.apis.condenser.models.FindSmtTokenByName;
import com.beowulfchain.beowulfj.protocol.enums.AssetSymbolType;
import com.beowulfchain.beowulfj.util.BeowulfJUtils;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.security.InvalidParameterException;
import java.util.Collections;
import org.joou.UInteger;

@JsonDeserialize(using=AssetDeserializer.class)
@JsonSerialize(using=AssetSerializer.class)
public class Asset
implements ByteTransformable {
    private long amount;
    private String name;
    private byte precision;

    private Asset() {
    }

    public Asset(BigDecimal amount, AssetSymbolType name) {
        this.setPrecision(UInteger.valueOf((int)5));
        this.setName(name.name());
        this.setAmount(amount);
    }

    public Asset(long amount, AssetSymbolType name) {
        this.setPrecision(UInteger.valueOf((int)5));
        this.setName(name.name());
        this.setAmount(amount);
    }

    public Asset(BigDecimal amount, String name, UInteger precision) {
        this.setName(name);
        this.setPrecision(precision);
        this.setAmount(amount);
    }

    public Asset(long amount, String name, UInteger precision) {
        this.setName(name);
        this.setPrecision(precision);
        this.setAmount(amount);
    }

    public static Asset createSmtAsset(BigDecimal amount, String name) throws BeowulfCommunicationException, BeowulfResponseException, BeowulfInvalidTransactionException {
        Asset asset = new Asset();
        if (AssetSymbolType.getValue(name) != null) {
            asset.setPrecision(UInteger.valueOf((int)5));
            asset.setName(name);
            asset.setAmount(amount);
        } else {
            FindSmtTokenByName tokenInfo = BeowulfJ.getInstance().findSmtTokenByName(Collections.singletonList(name)).get(0);
            UInteger decimals = tokenInfo.getLiquid_symbol().getDecimals();
            asset.setPrecision(decimals);
            asset.setName(name);
            asset.setAmount(amount);
        }
        return asset;
    }

    public Long getAmount() {
        return this.amount;
    }

    public void setAmount(long amount) {
        this.amount = amount;
    }

    public void setAmount(BigDecimal amount) {
        if (amount.scale() > this.getPrecision().intValue()) {
            throw new InvalidParameterException("The provided 'amount' has a 'scale' of " + amount.scale() + ", but needs to have a 'scale' of " + this.getPrecision() + " when " + this.getName() + " is used as a AssetSymbolType.");
        }
        this.amount = amount.multiply(BigDecimal.valueOf(Math.pow(10.0, this.getPrecision().intValue()))).longValue();
    }

    public void setAmount(String amount) {
        BigDecimal amountDecimal = new BigDecimal(amount);
        this.setAmount(amountDecimal);
    }

    public UInteger getPrecision() {
        return UInteger.valueOf((int)this.precision);
    }

    public void setPrecision(UInteger precision) {
        this.precision = precision.byteValue();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSymbol(AssetSymbolType symbol) {
        this.name = symbol.name();
    }

    public BigDecimal toReal() {
        BigDecimal transformedValue = new BigDecimal(this.getAmount());
        return transformedValue.divide(BigDecimal.valueOf(Math.pow(10.0, this.getPrecision().intValue())));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] toByteArray() throws BeowulfInvalidTransactionException {
        try (ByteArrayOutputStream serializedAsset = new ByteArrayOutputStream();){
            serializedAsset.write(BeowulfJUtils.transformLongToByteArray(this.amount));
            String filledAssetSymbol = this.name.toUpperCase();
            serializedAsset.write(BeowulfJUtils.transformIntToByteArray(this.precision));
            serializedAsset.write(this.name.toUpperCase().getBytes(BeowulfJConfig.getInstance().getEncodingCharset()));
            for (int i = filledAssetSymbol.length(); i < 9; ++i) {
                serializedAsset.write(0);
            }
            byte[] byArray = serializedAsset.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new BeowulfInvalidTransactionException("A problem occured while transforming an asset into a byte array.", e);
        }
    }

    public String toString() {
        String result = BigDecimal.valueOf(this.getAmount()).divide(BigDecimal.valueOf(100000L)).toPlainString() + " " + this.getName();
        return result;
    }

    public boolean equals(Object otherAsset) {
        if (this == otherAsset) {
            return true;
        }
        if (otherAsset == null || !(otherAsset instanceof Asset)) {
            return false;
        }
        Asset other = (Asset)otherAsset;
        return this.getAmount().equals(other.getAmount()) && this.getName().equals(other.getName()) && this.getPrecision().equals((Object)other.getPrecision());
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAmount() == null ? 0 : this.getAmount().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getPrecision() == null ? 0 : this.getPrecision().hashCode());
        return hashCode;
    }
}

