/*
 * Decompiled with CFR 0.152.
 */
package com.beowulfchain.beowulfj.protocol;

import com.beowulfchain.beowulfj.communication.CommunicationHandler;
import com.beowulfchain.beowulfj.configuration.BeowulfJConfig;
import com.beowulfchain.beowulfj.exceptions.BeowulfInvalidTransactionException;
import com.beowulfchain.beowulfj.interfaces.ByteTransformable;
import com.beowulfchain.beowulfj.protocol.operations.BaseOperation;
import com.beowulfchain.beowulfj.util.BeowulfJUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.joou.UInteger;

public class AssetInfo
extends BaseOperation
implements ByteTransformable {
    private UInteger decimals;
    private String name;

    public AssetInfo() {
    }

    public AssetInfo(String name, UInteger decimals) throws Exception {
        this.setName(name);
        this.setDecimals(decimals);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) throws Exception {
        if (name.length() > 8) {
            throw new Exception("number character of asset name must lower than 8");
        }
        this.name = name.toUpperCase();
    }

    public UInteger getDecimals() {
        return this.decimals;
    }

    public void setDecimals(UInteger decimals) throws Exception {
        if (decimals.intValue() > 5) {
            throw new Exception("decimals must lower than 5");
        }
        this.decimals = decimals;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] toByteArray() throws BeowulfInvalidTransactionException {
        try (ByteArrayOutputStream serializedSymbol = new ByteArrayOutputStream(12);){
            serializedSymbol.write(BeowulfJUtils.transformIntToByteArray(this.getDecimals().intValue()));
            serializedSymbol.write(this.getName().toUpperCase().getBytes(BeowulfJConfig.getInstance().getEncodingCharset()));
            for (int i = this.getName().length(); i < 9; ++i) {
                serializedSymbol.write(0);
            }
            byte[] byArray = serializedSymbol.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new BeowulfInvalidTransactionException("A problem occured while transforming the symbol into a byte array.", e);
        }
    }

    public String toJson() throws JsonProcessingException {
        return CommunicationHandler.getObjectMapper().writeValueAsString((Object)this);
    }
}

