/*
 * Decompiled with CFR 0.152.
 */
package com.beowulfchain.beowulfj.protocol;

import com.beowulfchain.beowulfj.base.models.deserializer.AccountAuthHashMapDeserializer;
import com.beowulfchain.beowulfj.base.models.deserializer.PublicKeyHashMapDeserializer;
import com.beowulfchain.beowulfj.base.models.serializer.AccountAuthHashMapSerializer;
import com.beowulfchain.beowulfj.base.models.serializer.PublicKeyHashMapSerializer;
import com.beowulfchain.beowulfj.exceptions.BeowulfInvalidParamException;
import com.beowulfchain.beowulfj.exceptions.BeowulfInvalidTransactionException;
import com.beowulfchain.beowulfj.interfaces.ByteTransformable;
import com.beowulfchain.beowulfj.interfaces.SignatureObject;
import com.beowulfchain.beowulfj.protocol.AccountName;
import com.beowulfchain.beowulfj.protocol.PublicKey;
import com.beowulfchain.beowulfj.util.BeowulfJUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class Authority
implements ByteTransformable,
SignatureObject {
    @JsonProperty(value="weight_threshold")
    private long weightThreshold;
    @JsonSerialize(using=AccountAuthHashMapSerializer.class)
    @JsonDeserialize(using=AccountAuthHashMapDeserializer.class)
    @JsonProperty(value="account_auths")
    private Map<AccountName, Integer> accountAuths;
    @JsonSerialize(using=PublicKeyHashMapSerializer.class)
    @JsonDeserialize(using=PublicKeyHashMapDeserializer.class)
    @JsonProperty(value="key_auths")
    private Map<PublicKey, Integer> keyAuths;

    public Authority() {
        this.setAccountAuths(new HashMap<AccountName, Integer>());
        this.setKeyAuths(new HashMap<PublicKey, Integer>());
        this.setWeightThreshold(1L);
    }

    public long getWeightThreshold() {
        return this.weightThreshold;
    }

    public void setWeightThreshold(long weightThreshold) {
        if (weightThreshold < 1L) {
            throw new BeowulfInvalidParamException("Weight threshold must not lower than 1");
        }
        this.weightThreshold = weightThreshold;
    }

    public Map<AccountName, Integer> getAccountAuths() {
        return this.accountAuths;
    }

    public void setAccountAuths(Map<AccountName, Integer> accountAuths) {
        this.accountAuths = accountAuths;
    }

    public Map<PublicKey, Integer> getKeyAuths() {
        return this.keyAuths;
    }

    public void setKeyAuths(Map<PublicKey, Integer> keyAuths) {
        this.keyAuths = keyAuths;
    }

    @JsonIgnore
    public boolean isImpossible() {
        long authWeights = 0L;
        for (int weight : this.getAccountAuths().values()) {
            authWeights += (long)weight;
        }
        for (int weight : this.getKeyAuths().values()) {
            authWeights += (long)weight;
        }
        return authWeights < this.getWeightThreshold();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] toByteArray() throws BeowulfInvalidTransactionException {
        try (ByteArrayOutputStream serializedAuthority = new ByteArrayOutputStream();){
            serializedAuthority.write(BeowulfJUtils.transformIntToByteArray((int)this.getWeightThreshold()));
            serializedAuthority.write(BeowulfJUtils.transformLongToVarIntByteArray(this.getAccountAuths().size()));
            ArrayList<AccountName> accountAuthsKeySet = new ArrayList<AccountName>(this.getAccountAuths().keySet());
            accountAuthsKeySet.sort(Comparator.comparing(AccountName::getName));
            for (AccountName accountName : accountAuthsKeySet) {
                serializedAuthority.write(accountName.toByteArray());
                serializedAuthority.write(BeowulfJUtils.transformShortToByteArray(this.getAccountAuths().get(accountName)));
            }
            serializedAuthority.write(BeowulfJUtils.transformLongToVarIntByteArray(this.getKeyAuths().size()));
            ArrayList<PublicKey> keyAuthsKeySet = new ArrayList<PublicKey>(this.getKeyAuths().keySet());
            keyAuthsKeySet.sort(Comparator.comparing(PublicKey::getAddressFromPublicKey));
            for (PublicKey key : keyAuthsKeySet) {
                serializedAuthority.write(key.toByteArray());
                serializedAuthority.write(BeowulfJUtils.transformShortToByteArray(this.getKeyAuths().get(key)));
            }
            Object object = serializedAuthority.toByteArray();
            return object;
        }
        catch (IOException e) {
            throw new BeowulfInvalidTransactionException("A problem occured while transforming an asset into a byte array.", e);
        }
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public boolean equals(Object otherAuthority) {
        if (this == otherAuthority) {
            return true;
        }
        if (otherAuthority == null || !(otherAuthority instanceof Authority)) {
            return false;
        }
        Authority other = (Authority)otherAuthority;
        return this.getAccountAuths().equals(other.getAccountAuths()) && this.getKeyAuths().equals(other.getKeyAuths()) && this.getWeightThreshold() == other.getWeightThreshold();
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAccountAuths() == null ? 0 : this.getAccountAuths().hashCode());
        hashCode = 31 * hashCode + (this.getKeyAuths() == null ? 0 : this.getKeyAuths().hashCode());
        hashCode = 31 * hashCode + (int)(this.getWeightThreshold() ^ this.getWeightThreshold() >>> 32);
        return hashCode;
    }

    @JsonIgnore
    public boolean isEmpty() {
        return this.getAccountAuths().isEmpty() && this.getKeyAuths().isEmpty();
    }
}

