/*
 * Decompiled with CFR 0.152.
 */
package com.beowulfchain.beowulfj.protocol;

import com.beowulfchain.beowulfj.exceptions.BeowulfInvalidTransactionException;
import com.beowulfchain.beowulfj.interfaces.ByteTransformable;
import com.beowulfchain.beowulfj.util.BeowulfJUtils;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.security.InvalidParameterException;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class ExtensionValue
implements ByteTransformable {
    @JsonProperty(value="data")
    private String data;

    public ExtensionValue() {
    }

    public ExtensionValue(String data) {
        this.setData(data);
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        if (data == null) {
            throw new InvalidParameterException("Value of Extension not null");
        }
        this.data = data;
    }

    @Override
    public byte[] toByteArray() throws BeowulfInvalidTransactionException {
        return BeowulfJUtils.transformStringToVarIntByteArray(this.data);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public boolean equals(Object otherObject) {
        if (!(otherObject instanceof ExtensionValue)) {
            return false;
        }
        ExtensionValue otherExtensionValue = (ExtensionValue)otherObject;
        return this.getData().equals(otherExtensionValue.getData());
    }
}

