/*
 * Decompiled with CFR 0.152.
 */
package com.beowulfchain.beowulfj.protocol;

import com.beowulfchain.beowulfj.exceptions.BeowulfInvalidTransactionException;
import com.beowulfchain.beowulfj.interfaces.ByteTransformable;
import com.beowulfchain.beowulfj.protocol.Asset;
import com.beowulfchain.beowulfj.util.BeowulfJUtils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.InvalidParameterException;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class Price
implements ByteTransformable {
    @JsonProperty(value="base")
    private Asset base;
    @JsonProperty(value="quote")
    private Asset quote;

    @JsonCreator
    public Price(@JsonProperty(value="base") Asset base, @JsonProperty(value="quote") Asset quote) {
        this.base = base;
        this.quote = quote;
        this.validate();
    }

    public Asset getBase() {
        return this.base;
    }

    public void setBase(Asset base) {
        this.base = base;
        this.validate();
    }

    public Asset getQuote() {
        return this.quote;
    }

    public void setQuote(Asset quote) {
        this.quote = quote;
        this.validate();
    }

    public Asset multiply(Asset asset) {
        if (asset == null) {
            throw new InvalidParameterException("The asset can't be null");
        }
        if (asset.getName().equals(this.getBase().getName())) {
            if (this.getBase().getAmount() == 0L) {
                throw new InvalidParameterException("Can't multiply as the price base is 0.");
            }
            return new Asset(asset.getAmount() * this.getQuote().getAmount() / this.getBase().getAmount(), this.getQuote().getName(), this.getQuote().getPrecision());
        }
        if (asset.getName().equals(this.getQuote().getName())) {
            if (this.getQuote().getAmount() == 0L) {
                throw new InvalidParameterException("Can't multiply as the price quote is 0.");
            }
            return new Asset(asset.getAmount() * this.getBase().getAmount() / this.getQuote().getAmount(), this.getBase().getName(), this.getQuote().getPrecision());
        }
        throw new InvalidParameterException("The provided asset does not fulfill the requirements to perform the multiply operation.");
    }

    private void validate() {
        if (((Asset)((Object)BeowulfJUtils.setIfNotNull(this.base, "The base asset needs to be provided."))).getName() == ((Asset)((Object)BeowulfJUtils.setIfNotNull(this.quote, "The quote asset needs to be provided."))).getName()) {
            throw new InvalidParameterException("The base asset needs to have a different type than the quote asset.");
        }
        if (this.base.getAmount() <= 0L) {
            throw new InvalidParameterException("The base asset amount needs to be greater than 0.");
        }
        if (this.quote.getAmount() <= 0L) {
            throw new InvalidParameterException("The quote asset amount needs to be greater than 0.");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] toByteArray() throws BeowulfInvalidTransactionException {
        try (ByteArrayOutputStream serializedPriceObject = new ByteArrayOutputStream();){
            serializedPriceObject.write(this.getBase().toByteArray());
            serializedPriceObject.write(this.getQuote().toByteArray());
            byte[] byArray = serializedPriceObject.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new BeowulfInvalidTransactionException("A problem occured while transforming the object into a byte array.", e);
        }
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (otherObject == null || !(otherObject instanceof Price)) {
            return false;
        }
        Price otherPrice = (Price)otherObject;
        return this.getBase().equals(otherPrice.getBase()) && this.getQuote().equals(otherPrice.getQuote());
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBase() == null ? 0 : this.getBase().hashCode());
        hashCode = 31 * hashCode + (this.getQuote() == null ? 0 : this.getQuote().hashCode());
        return hashCode;
    }
}

