/*
 * Decompiled with CFR 0.152.
 */
package com.beowulfchain.beowulfj.protocol;

import com.beowulfchain.beowulfj.base.models.serializer.PublicKeySerializer;
import com.beowulfchain.beowulfj.configuration.BeowulfJConfig;
import com.beowulfchain.beowulfj.exceptions.BeowulfInvalidTransactionException;
import com.beowulfchain.beowulfj.interfaces.ByteTransformable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.primitives.Bytes;
import eu.bittrade.crypto.core.AddressFormatException;
import eu.bittrade.crypto.core.ECKey;
import eu.bittrade.crypto.core.base58.Base58;
import java.util.Arrays;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongycastle.crypto.digests.RIPEMD160Digest;
import org.spongycastle.math.ec.ECPoint;

@JsonSerialize(using=PublicKeySerializer.class)
public class PublicKey
implements ByteTransformable {
    private static final Logger LOGGER = LoggerFactory.getLogger(PublicKey.class);
    private static final int CHECKSUM_BYTES = 4;
    private ECKey publicKey;
    private String prefix;

    @JsonCreator
    public PublicKey(String address) {
        if (address != null && !"".equals(address)) {
            if (address.length() != 53) {
                LOGGER.warn("The provided address '{}' has an invalid length and will not be set.", (Object)address);
                this.setPublicKey(null);
            } else {
                this.prefix = address.substring(0, 3);
                byte[] decodedAddress = Base58.decode((String)address.substring(3, address.length()));
                byte[] potentialPublicKey = Arrays.copyOfRange(decodedAddress, 0, decodedAddress.length - 4);
                byte[] expectedChecksum = Arrays.copyOfRange(decodedAddress, decodedAddress.length - 4, decodedAddress.length);
                byte[] actualChecksum = this.calculateChecksum(potentialPublicKey);
                for (int i = 0; i < expectedChecksum.length; ++i) {
                    if (expectedChecksum[i] == actualChecksum[i]) continue;
                    throw new AddressFormatException("Checksum does not match.");
                }
                this.setPublicKey(ECKey.fromPublicOnly((byte[])potentialPublicKey));
            }
        } else {
            LOGGER.warn("An empty address has been provided. This can cause some problems if you plan to broadcast this key.");
            this.setPublicKey(null);
        }
    }

    public PublicKey(ECKey publicKey) {
        this.setPublicKey(publicKey);
        this.prefix = BeowulfJConfig.getInstance().getAddressPrefix().toString().toUpperCase();
    }

    private byte[] calculateChecksum(byte[] publicKey) {
        RIPEMD160Digest ripemd160Digest = new RIPEMD160Digest();
        ripemd160Digest.update(publicKey, 0, publicKey.length);
        byte[] actualChecksum = new byte[ripemd160Digest.getDigestSize()];
        ripemd160Digest.doFinal(actualChecksum, 0);
        return actualChecksum;
    }

    @JsonIgnore
    public String getAddressFromPublicKey() {
        try {
            return this.prefix + Base58.encode((byte[])Bytes.concat((byte[][])new byte[][]{this.toByteArray(), Arrays.copyOfRange(this.calculateChecksum(this.toByteArray()), 0, 4)}));
        }
        catch (BeowulfInvalidTransactionException | NullPointerException e) {
            LOGGER.debug("An error occured while generating an address from a public key.", (Throwable)e);
            return "";
        }
    }

    @JsonIgnore
    public ECKey getPublicKey() {
        return this.publicKey;
    }

    private void setPublicKey(ECKey publicKey) {
        this.publicKey = publicKey;
    }

    @Override
    public byte[] toByteArray() throws BeowulfInvalidTransactionException {
        if (this.getPublicKey().isCompressed()) {
            return this.getPublicKey().getPubKey();
        }
        return ECKey.fromPublicOnly((ECPoint)ECKey.compressPoint((ECPoint)this.getPublicKey().getPubKeyPoint())).getPubKey();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public boolean equals(Object otherPublicKey) {
        if (this == otherPublicKey) {
            return true;
        }
        if (otherPublicKey == null || !(otherPublicKey instanceof PublicKey)) {
            return false;
        }
        PublicKey otherKey = (PublicKey)otherPublicKey;
        return this.getPublicKey().equals((Object)otherKey.getPublicKey());
    }

    public int hashCode() {
        return this.getPublicKey().hashCode();
    }
}

