/*
 * Decompiled with CFR 0.152.
 */
package com.beowulfchain.beowulfj.protocol;

import com.beowulfchain.beowulfj.exceptions.BeowulfInvalidTransactionException;
import com.beowulfchain.beowulfj.interfaces.ByteTransformable;
import com.beowulfchain.beowulfj.protocol.operations.BaseOperation;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.joou.UInteger;

public class Symbol
extends BaseOperation
implements ByteTransformable {
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="decimals")
    private UInteger decimals;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public UInteger getDecimals() {
        return this.decimals;
    }

    public void setDecimals(UInteger decimals) {
        this.decimals = decimals;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] toByteArray() throws BeowulfInvalidTransactionException {
        int BEOWULF_NAI_SHIFT = 5;
        int SMT_ASSET_NUM_CONTROL_MASK = 16;
        try (ByteArrayOutputStream serializedAccountUpdateOperation = new ByteArrayOutputStream();){
            String asset = this.getName().substring(2);
            int asset_num = Integer.parseInt(asset);
            int bytecode = asset_num << BEOWULF_NAI_SHIFT | SMT_ASSET_NUM_CONTROL_MASK | this.getDecimals().intValue();
            serializedAccountUpdateOperation.write(bytecode);
            byte[] byArray = serializedAccountUpdateOperation.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new BeowulfInvalidTransactionException("A problem occured while transforming the symbol into a byte array.", e);
        }
    }
}

