/*
 * Decompiled with CFR 0.152.
 */
package com.beowulfchain.beowulfj.protocol.operations;

import com.beowulfchain.beowulfj.configuration.BeowulfJConfig;
import com.beowulfchain.beowulfj.enums.PrivateKeyType;
import com.beowulfchain.beowulfj.enums.ValidationType;
import com.beowulfchain.beowulfj.interfaces.SignatureObject;
import com.beowulfchain.beowulfj.protocol.AccountName;
import com.beowulfchain.beowulfj.protocol.Asset;
import com.beowulfchain.beowulfj.protocol.Authority;
import com.beowulfchain.beowulfj.protocol.operations.AbstractAccountOperation;
import com.beowulfchain.beowulfj.util.BeowulfJUtils;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.security.InvalidParameterException;
import java.util.Map;

public abstract class AbstractAccountCreateOperation
extends AbstractAccountOperation {
    @JsonProperty(value="fee")
    protected Asset fee;
    @JsonProperty(value="creator")
    protected AccountName creator;
    @JsonProperty(value="new_account_name")
    protected AccountName newAccountName;

    protected AbstractAccountCreateOperation(boolean virtual) {
        super(virtual);
    }

    public Asset getFee() {
        return this.fee;
    }

    public void setFee(Asset fee) {
        this.fee = (Asset)((Object)BeowulfJUtils.setIfNotNull(fee, "The fee can't be null."));
    }

    public AccountName getCreator() {
        return this.creator;
    }

    public void setCreator(AccountName creator) {
        this.creator = (AccountName)((Object)BeowulfJUtils.setIfNotNull(creator, "The creator can't be null."));
    }

    public AccountName getNewAccountName() {
        return this.newAccountName;
    }

    public void setNewAccountName(AccountName newAccountName) {
        this.newAccountName = (AccountName)((Object)BeowulfJUtils.setIfNotNull(newAccountName, "The new account name can't be null."));
    }

    @Override
    public Authority getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(Authority owner) {
        this.owner = (Authority)((Object)BeowulfJUtils.setIfNotNull(owner, "The owner can't be null."));
    }

    @Override
    public Map<SignatureObject, PrivateKeyType> getRequiredAuthorities(Map<SignatureObject, PrivateKeyType> requiredAuthoritiesBase) {
        return this.mergeRequiredAuthorities(requiredAuthoritiesBase, this.getCreator(), PrivateKeyType.OWNER);
    }

    @Override
    public void validate(ValidationType validationType) {
        if (!ValidationType.SKIP_VALIDATION.equals((Object)validationType)) {
            super.validate(validationType);
            if (!ValidationType.SKIP_ASSET_VALIDATION.equals((Object)validationType)) {
                if (!this.fee.getName().equals(BeowulfJConfig.getInstance().getDollarSymbol().name())) {
                    throw new InvalidParameterException("The fee must be paid in W.");
                }
                if (this.fee.getAmount() < 0L) {
                    throw new InvalidParameterException("The fee must be a positive amount.");
                }
            }
        }
    }
}

