/*
 * Decompiled with CFR 0.152.
 */
package com.beowulfchain.beowulfj.protocol.operations;

import com.beowulfchain.beowulfj.enums.PrivateKeyType;
import com.beowulfchain.beowulfj.enums.ValidationType;
import com.beowulfchain.beowulfj.interfaces.SignatureObject;
import com.beowulfchain.beowulfj.protocol.AccountName;
import com.beowulfchain.beowulfj.protocol.Asset;
import com.beowulfchain.beowulfj.protocol.operations.Operation;
import com.beowulfchain.beowulfj.util.BeowulfJUtils;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.security.InvalidParameterException;
import java.util.Map;

abstract class AbstractTransferOperation
extends Operation {
    @JsonProperty(value="from")
    protected AccountName from;
    @JsonProperty(value="to")
    protected AccountName to;
    @JsonProperty(value="amount")
    protected Asset amount;
    @JsonProperty(value="fee")
    private Asset fee;

    protected AbstractTransferOperation(boolean virtual) {
        super(virtual);
    }

    public AccountName getFrom() {
        return this.from;
    }

    public void setFrom(AccountName from) {
        this.from = (AccountName)((Object)BeowulfJUtils.setIfNotNull(from, "The from account can't be null."));
    }

    public AccountName getTo() {
        return this.to;
    }

    public void setTo(AccountName to) {
        this.to = (AccountName)((Object)BeowulfJUtils.setIfNotNull(to, "The to account can't be null."));
    }

    public Asset getAmount() {
        return this.amount;
    }

    public void setAmount(Asset amount) {
        this.amount = (Asset)((Object)BeowulfJUtils.setIfNotNull(amount, "The amount can't be null."));
    }

    public Asset getFee() {
        return this.fee;
    }

    public void setFee(Asset fee) {
        this.fee = fee;
    }

    @Override
    public Map<SignatureObject, PrivateKeyType> getRequiredAuthorities(Map<SignatureObject, PrivateKeyType> requiredAuthoritiesBase) {
        return this.mergeRequiredAuthorities(requiredAuthoritiesBase, this.getFrom(), PrivateKeyType.OWNER);
    }

    @Override
    public void validate(ValidationType validationType) {
        if (!ValidationType.SKIP_ASSET_VALIDATION.equals((Object)validationType) && !ValidationType.SKIP_VALIDATION.equals((Object)validationType) && this.amount.getAmount() <= 0L) {
            throw new InvalidParameterException("Must transfer a nonzero amount.");
        }
    }
}

