/*
 * Decompiled with CFR 0.152.
 */
package com.beowulfchain.beowulfj.protocol.operations;

import com.beowulfchain.beowulfj.enums.OperationType;
import com.beowulfchain.beowulfj.exceptions.BeowulfInvalidTransactionException;
import com.beowulfchain.beowulfj.protocol.AccountName;
import com.beowulfchain.beowulfj.protocol.Asset;
import com.beowulfchain.beowulfj.protocol.Authority;
import com.beowulfchain.beowulfj.protocol.operations.AbstractAccountCreateOperation;
import com.beowulfchain.beowulfj.util.BeowulfJUtils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class AccountCreateOperation
extends AbstractAccountCreateOperation {
    @JsonCreator
    public AccountCreateOperation(@JsonProperty(value="creator") AccountName creator, @JsonProperty(value="fee") Asset fee, @JsonProperty(value="new_account_name") AccountName newAccountName, @JsonProperty(value="owner") Authority owner, @JsonProperty(value="json_metadata") String jsonMetadata) {
        super(false);
        this.setCreator(creator);
        this.setFee(fee);
        this.setNewAccountName(newAccountName);
        this.setOwner(owner);
        this.setJsonMetadata(jsonMetadata);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] toByteArray() throws BeowulfInvalidTransactionException {
        try (ByteArrayOutputStream serializedAccountCreateOperation = new ByteArrayOutputStream();){
            serializedAccountCreateOperation.write(BeowulfJUtils.transformIntToVarIntByteArray(OperationType.ACCOUNT_CREATE_OPERATION.getOrderId()));
            serializedAccountCreateOperation.write(this.getFee().toByteArray());
            serializedAccountCreateOperation.write(this.getCreator().toByteArray());
            serializedAccountCreateOperation.write(this.getNewAccountName().toByteArray());
            serializedAccountCreateOperation.write(this.getOwner().toByteArray());
            serializedAccountCreateOperation.write(BeowulfJUtils.transformStringToVarIntByteArray(this.getJsonMetadata()));
            byte[] byArray = serializedAccountCreateOperation.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new BeowulfInvalidTransactionException("A problem occured while transforming the operation into a byte array.", e);
        }
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

