/*
 * Decompiled with CFR 0.152.
 */
package com.beowulfchain.beowulfj.protocol.operations;

import com.beowulfchain.beowulfj.enums.OperationType;
import com.beowulfchain.beowulfj.enums.PrivateKeyType;
import com.beowulfchain.beowulfj.enums.ValidationType;
import com.beowulfchain.beowulfj.exceptions.BeowulfInvalidTransactionException;
import com.beowulfchain.beowulfj.interfaces.SignatureObject;
import com.beowulfchain.beowulfj.protocol.AccountName;
import com.beowulfchain.beowulfj.protocol.Asset;
import com.beowulfchain.beowulfj.protocol.operations.Operation;
import com.beowulfchain.beowulfj.util.BeowulfJUtils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class AccountSupernodeVoteOperation
extends Operation {
    @JsonProperty(value="account")
    private AccountName account;
    @JsonProperty(value="supernode")
    private AccountName supernode;
    @JsonProperty(value="approve")
    private boolean approve;
    @JsonProperty(value="fee")
    private Asset fee;

    @JsonCreator
    public AccountSupernodeVoteOperation(@JsonProperty(value="account") AccountName account, @JsonProperty(value="supernode") AccountName supernode, @JsonProperty(value="approve") boolean approve, @JsonProperty(value="fee") Asset fee) {
        super(false);
        this.setAccount(account);
        this.setSupernode(supernode);
        this.setApprove(approve);
        this.setFee(fee);
    }

    public AccountSupernodeVoteOperation(AccountName account, AccountName supernode, Asset fee) {
        this(account, supernode, true, fee);
    }

    public AccountName getAccount() {
        return this.account;
    }

    public void setAccount(AccountName account) {
        this.account = (AccountName)((Object)BeowulfJUtils.setIfNotNull(account, "The supernode acccount can't be null."));
    }

    public AccountName getSupernode() {
        return this.supernode;
    }

    public void setSupernode(AccountName supernode) {
        this.supernode = (AccountName)((Object)BeowulfJUtils.setIfNotNull(supernode, "The supernode acccount can't be null."));
    }

    public boolean getApprove() {
        return this.approve;
    }

    public void setApprove(boolean approve) {
        this.approve = approve;
    }

    public Asset getFee() {
        return this.fee;
    }

    public void setFee(Asset fee) {
        this.fee = fee;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] toByteArray() throws BeowulfInvalidTransactionException {
        try (ByteArrayOutputStream serializedAccountSupernodeVoteOperation = new ByteArrayOutputStream();){
            serializedAccountSupernodeVoteOperation.write(BeowulfJUtils.transformIntToVarIntByteArray(OperationType.ACCOUNT_SUPERNODE_VOTE_OPERATION.getOrderId()));
            serializedAccountSupernodeVoteOperation.write(this.getAccount().toByteArray());
            serializedAccountSupernodeVoteOperation.write(this.getSupernode().toByteArray());
            serializedAccountSupernodeVoteOperation.write(BeowulfJUtils.transformBooleanToByteArray(this.getApprove()));
            serializedAccountSupernodeVoteOperation.write(this.getFee().toByteArray());
            byte[] byArray = serializedAccountSupernodeVoteOperation.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new BeowulfInvalidTransactionException("A problem occured while transforming the operation into a byte array.", e);
        }
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    @Override
    public Map<SignatureObject, PrivateKeyType> getRequiredAuthorities(Map<SignatureObject, PrivateKeyType> requiredAuthoritiesBase) {
        return this.mergeRequiredAuthorities(requiredAuthoritiesBase, this.getAccount(), PrivateKeyType.OWNER);
    }

    @Override
    public void validate(ValidationType validationType) {
    }
}

