/*
 * Decompiled with CFR 0.152.
 */
package com.beowulfchain.beowulfj.protocol.operations;

import com.beowulfchain.beowulfj.enums.OperationType;
import com.beowulfchain.beowulfj.enums.PrivateKeyType;
import com.beowulfchain.beowulfj.exceptions.BeowulfInvalidTransactionException;
import com.beowulfchain.beowulfj.interfaces.SignatureObject;
import com.beowulfchain.beowulfj.protocol.AccountName;
import com.beowulfchain.beowulfj.protocol.Asset;
import com.beowulfchain.beowulfj.protocol.Authority;
import com.beowulfchain.beowulfj.protocol.operations.AbstractAccountOperation;
import com.beowulfchain.beowulfj.util.BeowulfJUtils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class AccountUpdateOperation
extends AbstractAccountOperation {
    @JsonProperty(value="account")
    private AccountName account;
    @JsonProperty(value="fee")
    private Asset fee;

    @JsonCreator
    public AccountUpdateOperation(@JsonProperty(value="account") AccountName account, @JsonProperty(value="owner") Authority owner, @JsonProperty(value="json_metadata") String jsonMetadata, @JsonProperty(value="fee") Asset fee) {
        super(false);
        this.setAccount(account);
        this.setOwner(owner);
        this.setJsonMetadata(jsonMetadata);
        this.setFee(fee);
    }

    @Override
    public Authority getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(Authority owner) {
        this.owner = owner;
    }

    public AccountName getAccount() {
        return this.account;
    }

    public void setAccount(AccountName account) {
        this.account = (AccountName)((Object)BeowulfJUtils.setIfNotNull(account, "The account can't be null."));
    }

    public Asset getFee() {
        return this.fee;
    }

    public void setFee(Asset fee) {
        this.fee = fee;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] toByteArray() throws BeowulfInvalidTransactionException {
        try (ByteArrayOutputStream serializedAccountUpdateOperation = new ByteArrayOutputStream();){
            serializedAccountUpdateOperation.write(BeowulfJUtils.transformIntToVarIntByteArray(OperationType.ACCOUNT_UPDATE_OPERATION.getOrderId()));
            serializedAccountUpdateOperation.write(this.getAccount().toByteArray());
            if (this.getOwner() != null) {
                serializedAccountUpdateOperation.write(this.getOwner().toByteArray());
            }
            serializedAccountUpdateOperation.write(BeowulfJUtils.transformStringToVarIntByteArray(this.getJsonMetadata()));
            serializedAccountUpdateOperation.write(this.getFee().toByteArray());
            byte[] byArray = serializedAccountUpdateOperation.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new BeowulfInvalidTransactionException("A problem occured while transforming the operation into a byte array.", e);
        }
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    @Override
    public Map<SignatureObject, PrivateKeyType> getRequiredAuthorities(Map<SignatureObject, PrivateKeyType> requiredAuthoritiesBase) {
        if (this.getOwner() != null) {
            return this.mergeRequiredAuthorities(requiredAuthoritiesBase, this.getAccount(), PrivateKeyType.OWNER);
        }
        return this.mergeRequiredAuthorities(requiredAuthoritiesBase, this.getAccount(), PrivateKeyType.OWNER);
    }
}

