/*
 * Decompiled with CFR 0.152.
 */
package com.beowulfchain.beowulfj.protocol.operations;

import com.beowulfchain.beowulfj.enums.PrivateKeyType;
import com.beowulfchain.beowulfj.interfaces.ByteTransformable;
import com.beowulfchain.beowulfj.interfaces.SignatureObject;
import com.beowulfchain.beowulfj.interfaces.Validatable;
import com.beowulfchain.beowulfj.protocol.operations.AccountCreateOperation;
import com.beowulfchain.beowulfj.protocol.operations.AccountSupernodeVoteOperation;
import com.beowulfchain.beowulfj.protocol.operations.AccountUpdateOperation;
import com.beowulfchain.beowulfj.protocol.operations.BaseOperation;
import com.beowulfchain.beowulfj.protocol.operations.SmtCreateOperation;
import com.beowulfchain.beowulfj.protocol.operations.SupernodeUpdateOperation;
import com.beowulfchain.beowulfj.protocol.operations.TransferOperation;
import com.beowulfchain.beowulfj.protocol.operations.TransferToVestingOperation;
import com.beowulfchain.beowulfj.protocol.operations.WithdrawVestingOperation;
import com.beowulfchain.beowulfj.protocol.operations.virtual.FillVestingWithdrawOperation;
import com.beowulfchain.beowulfj.protocol.operations.virtual.HardforkOperation;
import com.beowulfchain.beowulfj.protocol.operations.virtual.ProducerRewardOperation;
import com.beowulfchain.beowulfj.protocol.operations.virtual.ShutdownSupernodeOperation;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.ToStringBuilder;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.WRAPPER_ARRAY)
@JsonSubTypes(value={@JsonSubTypes.Type(value=TransferOperation.class, name="transfer"), @JsonSubTypes.Type(value=TransferToVestingOperation.class, name="transfer_to_vesting"), @JsonSubTypes.Type(value=WithdrawVestingOperation.class, name="withdraw_vesting"), @JsonSubTypes.Type(value=AccountCreateOperation.class, name="account_create"), @JsonSubTypes.Type(value=AccountUpdateOperation.class, name="account_update"), @JsonSubTypes.Type(value=SupernodeUpdateOperation.class, name="supernode_update"), @JsonSubTypes.Type(value=AccountSupernodeVoteOperation.class, name="account_supernode_vote"), @JsonSubTypes.Type(value=SmtCreateOperation.class, name="smt_create"), @JsonSubTypes.Type(value=FillVestingWithdrawOperation.class, name="fill_vesting_withdraw"), @JsonSubTypes.Type(value=ShutdownSupernodeOperation.class, name="shutdown_supernode"), @JsonSubTypes.Type(value=HardforkOperation.class, name="hardfork"), @JsonSubTypes.Type(value=ProducerRewardOperation.class, name="producer_reward")})
public abstract class Operation
extends BaseOperation
implements ByteTransformable,
Validatable {
    @JsonIgnore
    private boolean virtual;

    protected Operation(boolean virtual) {
        this.virtual = virtual;
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    public abstract Map<SignatureObject, PrivateKeyType> getRequiredAuthorities(Map<SignatureObject, PrivateKeyType> var1);

    protected Map<SignatureObject, PrivateKeyType> mergeRequiredAuthorities(Map<SignatureObject, PrivateKeyType> requiredAuthoritiesBase, SignatureObject signatureObject, PrivateKeyType privateKeyType) {
        Map<SignatureObject, PrivateKeyType> requiredAuthorities = requiredAuthoritiesBase;
        if (requiredAuthorities == null) {
            requiredAuthorities = new HashMap<SignatureObject, PrivateKeyType>();
        } else if (requiredAuthorities.containsKey(signatureObject) && requiredAuthorities.get(signatureObject) != null) {
            if (requiredAuthorities.get(signatureObject).ordinal() > privateKeyType.ordinal()) {
                requiredAuthorities.put(signatureObject, privateKeyType);
            }
        } else {
            requiredAuthorities.put(signatureObject, privateKeyType);
        }
        return requiredAuthorities;
    }

    protected Map<SignatureObject, PrivateKeyType> mergeRequiredAuthorities(Map<SignatureObject, PrivateKeyType> requiredAuthoritiesBase, List<? extends SignatureObject> signatureObjects, PrivateKeyType privateKeyType) {
        Map<SignatureObject, PrivateKeyType> requiredAuthorities = requiredAuthoritiesBase;
        for (SignatureObject signatureObject : signatureObjects) {
            requiredAuthorities = this.mergeRequiredAuthorities(requiredAuthorities, signatureObject, privateKeyType);
        }
        return requiredAuthorities;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

