/*
 * Decompiled with CFR 0.152.
 */
package com.beowulfchain.beowulfj.protocol.operations;

import com.beowulfchain.beowulfj.configuration.BeowulfJConfig;
import com.beowulfchain.beowulfj.enums.OperationType;
import com.beowulfchain.beowulfj.enums.PrivateKeyType;
import com.beowulfchain.beowulfj.enums.ValidationType;
import com.beowulfchain.beowulfj.exceptions.BeowulfInvalidTransactionException;
import com.beowulfchain.beowulfj.interfaces.SignatureObject;
import com.beowulfchain.beowulfj.protocol.AccountName;
import com.beowulfchain.beowulfj.protocol.Asset;
import com.beowulfchain.beowulfj.protocol.PublicKey;
import com.beowulfchain.beowulfj.protocol.operations.Operation;
import com.beowulfchain.beowulfj.util.BeowulfJUtils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.InvalidParameterException;
import java.util.Map;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class SupernodeUpdateOperation
extends Operation {
    @JsonProperty(value="owner")
    private AccountName owner;
    @JsonProperty(value="block_signing_key")
    private PublicKey blockSigningKey;
    @JsonProperty(value="fee")
    private Asset fee;

    @JsonCreator
    public SupernodeUpdateOperation(@JsonProperty(value="owner") AccountName owner, @JsonProperty(value="block_signing_key") PublicKey blockSigningKey, @JsonProperty(value="fee") Asset fee) {
        super(false);
        this.setOwner(owner);
        this.setBlockSigningKey(blockSigningKey);
        this.setFee(fee);
    }

    public AccountName getOwner() {
        return this.owner;
    }

    public void setOwner(AccountName owner) {
        this.owner = (AccountName)((Object)BeowulfJUtils.setIfNotNull(owner, "The owner can't be null."));
    }

    public PublicKey getBlockSigningKey() {
        return this.blockSigningKey;
    }

    public void setBlockSigningKey(PublicKey blockSigningKey) {
        this.blockSigningKey = (PublicKey)((Object)BeowulfJUtils.setIfNotNull(blockSigningKey, "You need to provide a block signing key."));
    }

    public Asset getFee() {
        return this.fee;
    }

    public void setFee(Asset fee) {
        this.fee = (Asset)((Object)BeowulfJUtils.setIfNotNull(fee, "The fee can't be null."));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] toByteArray() throws BeowulfInvalidTransactionException {
        try (ByteArrayOutputStream serializedSupernodeUpdateOperation = new ByteArrayOutputStream();){
            serializedSupernodeUpdateOperation.write(BeowulfJUtils.transformIntToVarIntByteArray(OperationType.SUPERNODE_UPDATE_OPERATION.getOrderId()));
            serializedSupernodeUpdateOperation.write(this.getOwner().toByteArray());
            serializedSupernodeUpdateOperation.write(this.getBlockSigningKey().toByteArray());
            serializedSupernodeUpdateOperation.write(this.getFee().toByteArray());
            byte[] byArray = serializedSupernodeUpdateOperation.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new BeowulfInvalidTransactionException("A problem occured while transforming the operation into a byte array.", e);
        }
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    @Override
    public Map<SignatureObject, PrivateKeyType> getRequiredAuthorities(Map<SignatureObject, PrivateKeyType> requiredAuthoritiesBase) {
        return this.mergeRequiredAuthorities(requiredAuthoritiesBase, this.getOwner(), PrivateKeyType.OWNER);
    }

    @Override
    public void validate(ValidationType validationType) {
        if (!(ValidationType.SKIP_ASSET_VALIDATION.equals((Object)validationType) || ValidationType.SKIP_VALIDATION.equals((Object)validationType) || this.getFee().getAmount() >= 0L && BeowulfJConfig.getInstance().getTokenSymbol().equals(this.getFee().getName()))) {
            throw new InvalidParameterException("The fee needs to be a positive amount of BWF.");
        }
    }
}

