/*
 * Decompiled with CFR 0.152.
 */
package com.beowulfchain.beowulfj.protocol.operations;

import com.beowulfchain.beowulfj.configuration.BeowulfJConfig;
import com.beowulfchain.beowulfj.enums.OperationType;
import com.beowulfchain.beowulfj.enums.ValidationType;
import com.beowulfchain.beowulfj.exceptions.BeowulfInvalidTransactionException;
import com.beowulfchain.beowulfj.protocol.AccountName;
import com.beowulfchain.beowulfj.protocol.Asset;
import com.beowulfchain.beowulfj.protocol.operations.AbstractTransferOperation;
import com.beowulfchain.beowulfj.util.BeowulfJUtils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.InvalidParameterException;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class TransferOperation
extends AbstractTransferOperation {
    @JsonProperty(value="memo")
    private String memo;

    @JsonCreator
    public TransferOperation(@JsonProperty(value="from") AccountName from, @JsonProperty(value="to") AccountName to, @JsonProperty(value="amount") Asset amount, @JsonProperty(value="fee") Asset fee, @JsonProperty(value="memo") String memo) {
        super(false);
        this.setFrom(from);
        this.setTo(to);
        this.setAmount(amount);
        this.setFee(fee);
        this.setMemo(memo);
    }

    @Override
    public void setAmount(Asset amount) {
        this.amount = (Asset)((Object)BeowulfJUtils.setIfNotNull(amount, "The amount can't be null."));
    }

    public String getMemo() {
        return this.memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] toByteArray() throws BeowulfInvalidTransactionException {
        try (ByteArrayOutputStream serializedTransferOperation = new ByteArrayOutputStream();){
            serializedTransferOperation.write(BeowulfJUtils.transformIntToVarIntByteArray(OperationType.TRANSFER_OPERATION.getOrderId()));
            serializedTransferOperation.write(this.getFrom().toByteArray());
            serializedTransferOperation.write(this.getTo().toByteArray());
            serializedTransferOperation.write(this.getAmount().toByteArray());
            serializedTransferOperation.write(this.getFee().toByteArray());
            serializedTransferOperation.write(BeowulfJUtils.transformStringToVarIntByteArray(this.getMemo()));
            byte[] byArray = serializedTransferOperation.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new BeowulfInvalidTransactionException("A problem occured while transforming the operation into a byte array.", e);
        }
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    @Override
    public void validate(ValidationType validationType) {
        if (!ValidationType.SKIP_VALIDATION.equals((Object)validationType)) {
            super.validate(validationType);
            if (!ValidationType.SKIP_ASSET_VALIDATION.equals((Object)validationType)) {
                if (this.amount.getName().equals(BeowulfJConfig.getInstance().getVestsSymbol().name())) {
                    throw new InvalidParameterException("Transfering Beowulf Power (M) is not allowed.");
                }
                if (this.amount.getAmount() <= 0L) {
                    throw new InvalidParameterException("Must transfer a nonzero amount.");
                }
            }
            if (this.memo.length() > 2048) {
                throw new InvalidParameterException("The memo is too long. Only 2048 characters are allowed.");
            }
        }
    }
}

