/*
 * Decompiled with CFR 0.152.
 */
package com.beowulfchain.beowulfj.protocol.operations;

import com.beowulfchain.beowulfj.configuration.BeowulfJConfig;
import com.beowulfchain.beowulfj.enums.OperationType;
import com.beowulfchain.beowulfj.enums.ValidationType;
import com.beowulfchain.beowulfj.exceptions.BeowulfInvalidTransactionException;
import com.beowulfchain.beowulfj.protocol.AccountName;
import com.beowulfchain.beowulfj.protocol.Asset;
import com.beowulfchain.beowulfj.protocol.operations.AbstractTransferOperation;
import com.beowulfchain.beowulfj.util.BeowulfJUtils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.InvalidParameterException;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class TransferToVestingOperation
extends AbstractTransferOperation {
    @JsonCreator
    public TransferToVestingOperation(@JsonProperty(value="from") AccountName from, @JsonProperty(value="to") AccountName to, @JsonProperty(value="amount") Asset amount, @JsonProperty(value="fee") Asset fee) {
        super(false);
        this.setFrom(from);
        this.setTo(to);
        this.setAmount(amount);
        this.setFee(fee);
    }

    public TransferToVestingOperation(AccountName from, Asset amount, Asset fee) {
        this(from, from, amount, fee);
    }

    @Override
    public void setTo(AccountName to) {
        this.to = to == null ? new AccountName() : to;
    }

    @Override
    public void setAmount(Asset amount) {
        this.amount = (Asset)((Object)BeowulfJUtils.setIfNotNull(amount, "The amount can't be null."));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] toByteArray() throws BeowulfInvalidTransactionException {
        try (ByteArrayOutputStream serializedTransferToVestingOperation = new ByteArrayOutputStream();){
            serializedTransferToVestingOperation.write(BeowulfJUtils.transformIntToVarIntByteArray(OperationType.TRANSFER_TO_VESTING_OPERATION.getOrderId()));
            serializedTransferToVestingOperation.write(this.getFrom().toByteArray());
            serializedTransferToVestingOperation.write(this.getTo().toByteArray());
            serializedTransferToVestingOperation.write(this.getAmount().toByteArray());
            serializedTransferToVestingOperation.write(this.getFee().toByteArray());
            byte[] byArray = serializedTransferToVestingOperation.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new BeowulfInvalidTransactionException("A problem occured while transforming the operation into a byte array.", e);
        }
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    @Override
    public void validate(ValidationType validationType) {
        if (!(ValidationType.SKIP_VALIDATION.equals((Object)validationType) || ValidationType.SKIP_ASSET_VALIDATION.equals((Object)validationType) || this.amount.getName().equals((Object)BeowulfJConfig.getInstance().getTokenSymbol()))) {
            throw new InvalidParameterException("The amount must be of type BWF.");
        }
    }
}

