/*
 * Decompiled with CFR 0.152.
 */
package com.beowulfchain.beowulfj.protocol.operations;

import com.beowulfchain.beowulfj.configuration.BeowulfJConfig;
import com.beowulfchain.beowulfj.enums.OperationType;
import com.beowulfchain.beowulfj.enums.PrivateKeyType;
import com.beowulfchain.beowulfj.enums.ValidationType;
import com.beowulfchain.beowulfj.exceptions.BeowulfInvalidTransactionException;
import com.beowulfchain.beowulfj.interfaces.SignatureObject;
import com.beowulfchain.beowulfj.protocol.AccountName;
import com.beowulfchain.beowulfj.protocol.Asset;
import com.beowulfchain.beowulfj.protocol.operations.Operation;
import com.beowulfchain.beowulfj.util.BeowulfJUtils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.InvalidParameterException;
import java.util.Map;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class WithdrawVestingOperation
extends Operation {
    @JsonProperty(value="account")
    private AccountName account;
    @JsonProperty(value="vesting_shares")
    private Asset vestingShares;
    @JsonProperty(value="fee")
    private Asset fee;

    @JsonCreator
    public WithdrawVestingOperation(@JsonProperty(value="account") AccountName account, @JsonProperty(value="vesting_shares") Asset vestingShares, @JsonProperty(value="fee") Asset fee) {
        super(false);
        this.setFee(fee);
        this.setAccount(account);
        this.setVestingShares(vestingShares);
    }

    public AccountName getAccount() {
        return this.account;
    }

    public void setAccount(AccountName account) {
        this.account = (AccountName)((Object)BeowulfJUtils.setIfNotNull(account, "An account name needs to be provided."));
    }

    public Asset getVestingShares() {
        return this.vestingShares;
    }

    public void setVestingShares(Asset vestingShares) {
        this.vestingShares = (Asset)((Object)BeowulfJUtils.setIfNotNull(vestingShares, "The vesting shares can't be null."));
    }

    public Asset getFee() {
        return this.fee;
    }

    public void setFee(Asset fee) {
        this.fee = fee;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] toByteArray() throws BeowulfInvalidTransactionException {
        try (ByteArrayOutputStream serializedWithdrawVestingOperation = new ByteArrayOutputStream();){
            serializedWithdrawVestingOperation.write(BeowulfJUtils.transformIntToVarIntByteArray(OperationType.WITHDRAW_VESTING_OPERATION.getOrderId()));
            serializedWithdrawVestingOperation.write(this.getAccount().toByteArray());
            serializedWithdrawVestingOperation.write(this.getVestingShares().toByteArray());
            serializedWithdrawVestingOperation.write(this.getFee().toByteArray());
            byte[] byArray = serializedWithdrawVestingOperation.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new BeowulfInvalidTransactionException("A problem occured while transforming the operation into a byte array.", e);
        }
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    @Override
    public Map<SignatureObject, PrivateKeyType> getRequiredAuthorities(Map<SignatureObject, PrivateKeyType> requiredAuthoritiesBase) {
        return this.mergeRequiredAuthorities(requiredAuthoritiesBase, this.getAccount(), PrivateKeyType.OWNER);
    }

    @Override
    public void validate(ValidationType validationType) {
        if (!(ValidationType.SKIP_ASSET_VALIDATION.equals((Object)validationType) || ValidationType.SKIP_VALIDATION.equals((Object)validationType) || BeowulfJConfig.getInstance().getVestsSymbol().equals(this.getVestingShares().getName()))) {
            throw new InvalidParameterException("The vesting shares needs to be provided in M.");
        }
    }
}

