/*
 * Decompiled with CFR 0.152.
 */
package com.beowulfchain.beowulfj.util;

import com.beowulfchain.beowulfj.configuration.BeowulfJConfig;
import com.beowulfchain.beowulfj.protocol.PublicKey;
import com.fasterxml.jackson.databind.ObjectMapper;
import eu.bittrade.crypto.core.DumpedPrivateKey;
import eu.bittrade.crypto.core.ECKey;
import eu.bittrade.crypto.core.VarInt;
import eu.bittrade.crypto.core.base58.Base58ChecksumProvider;
import eu.bittrade.crypto.core.base58.Sha256ChecksumProvider;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.security.InvalidParameterException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeowulfJUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(BeowulfJUtils.class);

    private BeowulfJUtils() {
    }

    public static boolean verifyJsonString(String customJsonString) {
        boolean valid = true;
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.readTree(customJsonString);
        }
        catch (IOException e) {
            LOGGER.debug("The given json is invalid.", (Throwable)e);
            valid = false;
        }
        return valid;
    }

    public static byte[] transformShortToByteArray(int shortValue) {
        return ByteBuffer.allocate(2).order(ByteOrder.LITTLE_ENDIAN).putShort((short)shortValue).array();
    }

    public static byte[] transformLongToByteArray(long longValue) {
        return ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putLong(longValue).array();
    }

    public static byte transformByteToLittleEndian(byte byteValue) {
        return ByteBuffer.allocate(1).order(ByteOrder.LITTLE_ENDIAN).put(byteValue).get(0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] transformStringToVarIntByteArray(String string) {
        if (string == null) {
            return new byte[0];
        }
        Charset encodingCharset = BeowulfJConfig.getInstance().getEncodingCharset();
        try (ByteArrayOutputStream resultingByteRepresentation = new ByteArrayOutputStream();){
            byte[] stringAsByteArray = string.getBytes(encodingCharset);
            resultingByteRepresentation.write(BeowulfJUtils.transformLongToVarIntByteArray(stringAsByteArray.length));
            resultingByteRepresentation.write(stringAsByteArray);
            byte[] byArray = resultingByteRepresentation.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("A problem occured while transforming the string into a byte array.", e);
        }
    }

    public static byte[] transformIntToVarIntByteArray(int intValue) {
        try {
            int value = intValue;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(byteArrayOutputStream);
            while ((long)(value & 0xFFFFFF80) != 0L) {
                out.writeByte(value & 0x7F | 0x80);
                value >>>= 7;
            }
            out.writeByte(intValue & 0x7F);
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException e) {
            LOGGER.error("Could not transform the given int value into its VarInt representation - Using BitcoinJ as Fallback. This could cause problems for values > 127.", (Throwable)e);
            return new VarInt((long)intValue).encode();
        }
    }

    public static byte[] transformShortToByteArray(short shortValue) {
        return ByteBuffer.allocate(2).order(ByteOrder.LITTLE_ENDIAN).putShort(shortValue).array();
    }

    public static byte[] transformIntToByteArray(int intValue) {
        return ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putInt(intValue).array();
    }

    public static byte[] transformBooleanToByteArray(boolean boolValue) {
        return new byte[]{(byte)(boolValue ? 1 : 0)};
    }

    public static byte[] transformLongToVarIntByteArray(long longValue) {
        try {
            long value = longValue;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(byteArrayOutputStream);
            while ((value & 0xFFFFFFFFFFFFFF80L) != 0L) {
                out.writeByte((int)value & 0x7F | 0x80);
                value >>>= 7;
            }
            out.writeByte((int)value & 0x7F);
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException e) {
            LOGGER.error("Could not transform the given long value into its VarInt representation - Using BitcoinJ as Fallback. This could cause problems for values > 127.", (Throwable)e);
            return new VarInt(longValue).encode();
        }
    }

    public static String transformDateToString(Date date) {
        SimpleDateFormat simpleDateFormatForJSON = new SimpleDateFormat(BeowulfJConfig.getInstance().getDateTimePattern());
        simpleDateFormatForJSON.setTimeZone(TimeZone.getTimeZone(BeowulfJConfig.getInstance().getTimeZoneId()));
        return simpleDateFormatForJSON.format(date);
    }

    public static long transformStringToTimestamp(String dateTime) throws ParseException {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(BeowulfJConfig.getInstance().getDateTimePattern());
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone(BeowulfJConfig.getInstance().getTimeZoneId()));
        calendar.setTime(simpleDateFormat.parse(dateTime + BeowulfJConfig.getInstance().getTimeZoneId()));
        return calendar.getTimeInMillis();
    }

    public static String privateKeyToWIF(ECKey privateKey) {
        ECKey currentPrivateKey = privateKey;
        if (currentPrivateKey.isCompressed()) {
            currentPrivateKey = currentPrivateKey.decompress();
        }
        return currentPrivateKey.getPrivateKeyEncoded(Integer.valueOf(128)).toBase58();
    }

    public static <T> T setIfNotNull(T objectToSet, String message) {
        return BeowulfJUtils.setIfNotNull(objectToSet, message, null);
    }

    public static <T> T setIfNotNull(T objectToSet, String message, @Nullable T defaultValue) {
        if (objectToSet == null) {
            if (defaultValue != null) {
                return defaultValue;
            }
            throw new InvalidParameterException(message);
        }
        return objectToSet;
    }

    public static <T> T setIfNotNull(T objectToSet, @Nullable T defaultValue) {
        return BeowulfJUtils.setIfNotNull(objectToSet, "Both, the objectToSet and the default value are null.", defaultValue);
    }

    public static <T> List<T> setIfNotNullAndNotEmpty(List<T> collectionToSet, String message) {
        if (collectionToSet == null || collectionToSet.isEmpty()) {
            throw new InvalidParameterException(message);
        }
        return collectionToSet;
    }

    public static String byteToHex(byte num) {
        char[] hexDigits = new char[]{Character.forDigit(num >> 4 & 0xF, 16), Character.forDigit(num & 0xF, 16)};
        return new String(hexDigits);
    }

    public static byte[] decodeHexString(String hexString) {
        if (hexString.length() % 2 == 1) {
            throw new IllegalArgumentException("Invalid hexadecimal String supplied.");
        }
        byte[] bytes = new byte[hexString.length() / 2];
        for (int i = 0; i < hexString.length(); i += 2) {
            bytes[i / 2] = BeowulfJUtils.hexToByte(hexString.substring(i, i + 2));
        }
        return bytes;
    }

    public static byte hexToByte(String hexString) {
        int firstDigit = BeowulfJUtils.toDigit(hexString.charAt(0));
        int secondDigit = BeowulfJUtils.toDigit(hexString.charAt(1));
        return (byte)((firstDigit << 4) + secondDigit);
    }

    public static int toDigit(char hexChar) {
        int digit = Character.digit(hexChar, 16);
        if (digit == -1) {
            throw new IllegalArgumentException("Invalid Hexadecimal Character: " + hexChar);
        }
        return digit;
    }

    public static String getAddressFromEckey(ECKey ecKey) {
        PublicKey publicKey = new PublicKey(ecKey);
        return publicKey.getAddressFromPublicKey();
    }

    public static ECKey fromWifToEckey(String wif) {
        return DumpedPrivateKey.fromBase58((Integer)128, (String)wif, (Base58ChecksumProvider)new Sha256ChecksumProvider()).getKey();
    }

    public static String fromEckeyToWif(ECKey ecKey) {
        return ecKey.getPrivateKeyEncoded(Integer.valueOf(128)).toBase58();
    }

    public static String fromPrivKeyHexToWif(String hexString) {
        ECKey ecKey = ECKey.fromPrivate((BigInteger)new BigInteger(hexString, 16)).decompress();
        return BeowulfJUtils.fromEckeyToWif(ecKey);
    }
}

