/*
 * Decompiled with CFR 0.152.
 */
package com.beowulfchain.beowulfj.util;

import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BrainkeyDictionaryManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(BrainkeyDictionaryManager.class);
    private static final String DICTIONARY_FILE_NAME = "dictionary.txt";
    private static final String DICTIONARY_DELIMITER = ",";
    private static BrainkeyDictionaryManager brainkeyDictionaryManagerInstance;
    private String[] brainKeyDictionary;

    private BrainkeyDictionaryManager() throws IOException {
        try (FileReader fileReader = new FileReader(this.getClass().getClassLoader().getResource(DICTIONARY_FILE_NAME).getFile());){
            this.brainKeyDictionary = IOUtils.toString((Reader)fileReader).split(DICTIONARY_DELIMITER);
        }
    }

    public static BrainkeyDictionaryManager getInstance() {
        try {
            if (brainkeyDictionaryManagerInstance == null) {
                brainkeyDictionaryManagerInstance = new BrainkeyDictionaryManager();
            }
        }
        catch (IOException e) {
            LOGGER.error("Could not create a new BrainkeyDictionaryManager instance.", (Throwable)e);
        }
        return brainkeyDictionaryManagerInstance;
    }

    public String[] getBrainKeyDictionary() {
        return this.brainKeyDictionary;
    }
}

