/*
 * Decompiled with CFR 0.152.
 */
package com.beowulfchain.beowulfj.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CondenserUtils {
    private static final String TAGS_FIELD_NAME = "tags";
    private static final String USERS_FIELD_NAME = "users";
    private static final String IMAGES_FIELD_NAME = "images";
    private static final String LINKS_FIELD_NAME = "links";
    private static final String APP_FIELD_NAME = "app";
    private static final String FORMAT_FIELD_NAME = "format";

    private CondenserUtils() {
    }

    public static List<String> extractLinksFromContent(String content) {
        ArrayList<String> containedUrls = new ArrayList<String>();
        Pattern pattern = Pattern.compile("\\b((https?|ftp|file)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|])", 2);
        Matcher urlMatcher = pattern.matcher(content);
        while (urlMatcher.find()) {
            containedUrls.add(content.substring(urlMatcher.start(0), urlMatcher.end(0)));
        }
        return containedUrls;
    }

    public static List<String> extractUsersFromContent(String content) {
        ArrayList<String> containedUrls = new ArrayList<String>();
        Pattern pattern = Pattern.compile("(@{1})([a-z0-9\\.-]{3,16})", 2);
        Matcher urlMatcher = pattern.matcher(content);
        while (urlMatcher.find()) {
            containedUrls.add(content.substring(urlMatcher.start(2), urlMatcher.end(2)));
        }
        return containedUrls;
    }

    public static String generateBeowulfitMetadata(String content, String[] tags, String app, String format) {
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode jsonMetadata = objectMapper.createObjectNode();
        ArrayNode tagArray = jsonMetadata.arrayNode();
        for (String tag : tags) {
            tagArray.add(tag);
        }
        jsonMetadata.set(TAGS_FIELD_NAME, (JsonNode)tagArray);
        ArrayNode userArray = jsonMetadata.arrayNode();
        List<String> users = CondenserUtils.extractUsersFromContent(content);
        for (String user : users) {
            userArray.add(user);
        }
        if (userArray.size() > 0) {
            jsonMetadata.set(USERS_FIELD_NAME, (JsonNode)userArray);
        }
        ArrayNode imageArray = jsonMetadata.arrayNode();
        ArrayNode linksArray = jsonMetadata.arrayNode();
        List<String> links = CondenserUtils.extractLinksFromContent(content);
        for (String link : links) {
            if (link.matches("/(https?:\\/\\/.*\\.(?:png|jpg))/i")) {
                imageArray.add(link);
                continue;
            }
            linksArray.add(link);
        }
        if (imageArray.size() > 0) {
            jsonMetadata.set(IMAGES_FIELD_NAME, (JsonNode)imageArray);
        }
        if (linksArray.size() > 0) {
            jsonMetadata.set(LINKS_FIELD_NAME, (JsonNode)linksArray);
        }
        jsonMetadata.put(APP_FIELD_NAME, app);
        jsonMetadata.put(FORMAT_FIELD_NAME, format);
        return jsonMetadata.toString();
    }

    public static String createPermlinkString(String title) {
        return title.trim().toLowerCase().replaceAll(" ", "-").replaceAll("[^a-z0-9-]+", "").replaceAll("-+", "-");
    }
}

