/*
 * Decompiled with CFR 0.152.
 */
package com.beowulfchain.beowulfj.util;

import com.beowulfchain.beowulfj.configuration.BeowulfJConfig;
import com.beowulfchain.beowulfj.exceptions.BeowulfFatalErrorException;
import com.beowulfchain.beowulfj.exceptions.BeowulfKeyHandlingException;
import com.beowulfchain.beowulfj.protocol.PublicKey;
import com.beowulfchain.beowulfj.util.BeowulfJUtils;
import com.beowulfchain.beowulfj.util.BrainkeyDictionaryManager;
import eu.bittrade.crypto.core.ECKey;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;

public class KeyGenerator {
    private static final int BRAIN_KEY_WORD_COUNT = 16;
    private String brainKey;
    private ECKey privateKey;

    public KeyGenerator() throws BeowulfKeyHandlingException {
        try {
            this.setBrainKey(KeyGenerator.suggestBrainKey());
        }
        catch (BeowulfKeyHandlingException e) {
            throw new BeowulfFatalErrorException("The generated brain key was not valid - This should never happen.", e);
        }
        this.setPrivateKey(this.getBrainKey(), 0);
    }

    public KeyGenerator(String brainKey, int sequence) throws BeowulfKeyHandlingException {
        this.setBrainKey(brainKey);
        this.setPrivateKey(this.getBrainKey(), sequence);
    }

    public static String suggestBrainKey() throws BeowulfKeyHandlingException {
        ArrayList<String> brainKeyParts = new ArrayList<String>();
        try {
            for (int i = 0; i < 16; ++i) {
                brainKeyParts.add(BrainkeyDictionaryManager.getInstance().getBrainKeyDictionary()[SecureRandom.getInstance("SHA1PRNG", "SUN").nextInt(BrainkeyDictionaryManager.getInstance().getBrainKeyDictionary().length - 1)].toUpperCase());
            }
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new BeowulfKeyHandlingException("The algorithm used to provide a strong random number is not available on your system.", e);
        }
        return StringUtils.join(brainKeyParts, (String)" ");
    }

    public ECKey getPrivateKey() {
        return this.privateKey;
    }

    public String getPrivateKeyAsWIF() {
        return BeowulfJUtils.privateKeyToWIF(this.getPrivateKey());
    }

    private void setPrivateKey(String brainKey, int sequence) throws BeowulfKeyHandlingException {
        String brainKeyAndSquence = brainKey + " " + sequence;
        try {
            MessageDigest messageDigest512 = MessageDigest.getInstance("SHA-512");
            MessageDigest messageDigest256 = MessageDigest.getInstance("SHA-256");
            byte[] hashedBrainKeyAndSequence = messageDigest512.digest(brainKeyAndSquence.getBytes(BeowulfJConfig.getInstance().getEncodingCharset()));
            this.privateKey = ECKey.fromPrivate((byte[])messageDigest256.digest(hashedBrainKeyAndSequence));
        }
        catch (NoSuchAlgorithmException e) {
            throw new BeowulfKeyHandlingException("The algorithm used to generate a private key is not supported by your system.", e);
        }
    }

    public PublicKey getPublicKey() {
        return new PublicKey(ECKey.fromPrivate((byte[])this.getPrivateKey().getPrivKeyBytes()));
    }

    public String getBrainKey() {
        return this.brainKey;
    }

    private void setBrainKey(String brainKey) throws BeowulfKeyHandlingException {
        if (brainKey.split(" ").length != 16) {
            throw new BeowulfKeyHandlingException("The provided brain key has to be a space separated list of 16 words.");
        }
        this.brainKey = brainKey;
    }
}

