/*
 * Decompiled with CFR 0.152.
 */
package com.bernardomg.tabletop.dice.history;

import com.bernardomg.tabletop.dice.DefaultDice;
import com.bernardomg.tabletop.dice.Dice;
import com.bernardomg.tabletop.dice.history.RollResult;
import java.util.Arrays;
import java.util.Objects;
import lombok.NonNull;

public final class DefaultRollResult
implements RollResult {
    @NonNull
    private final Iterable<Integer> allRolls;
    @NonNull
    private final Dice dice;
    @NonNull
    private final Integer totalRoll;

    public DefaultRollResult(@NonNull Dice d, @NonNull Iterable<Integer> rolls, @NonNull Integer total) {
        this.dice = Objects.requireNonNull(d, "Received a null pointer as dice");
        this.allRolls = Objects.requireNonNull(rolls, "Received a null pointer as rolls");
        this.totalRoll = Objects.requireNonNull(total, "Received a null pointer as total roll");
    }

    public DefaultRollResult(@NonNull Integer total) {
        if (total == null) {
            throw new NullPointerException("total is marked non-null but is null");
        }
        this.dice = new DefaultDice(1, total);
        this.totalRoll = Objects.requireNonNull(total, "Received a null pointer as total roll");
        this.allRolls = Arrays.asList(total);
    }

    @Override
    @NonNull
    public Iterable<Integer> getAllRolls() {
        return this.allRolls;
    }

    @Override
    @NonNull
    public Dice getDice() {
        return this.dice;
    }

    @Override
    @NonNull
    public Integer getTotalRoll() {
        return this.totalRoll;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultRollResult)) {
            return false;
        }
        DefaultRollResult other = (DefaultRollResult)o;
        Integer this$totalRoll = this.getTotalRoll();
        Integer other$totalRoll = other.getTotalRoll();
        if (this$totalRoll == null ? other$totalRoll != null : !((Object)this$totalRoll).equals(other$totalRoll)) {
            return false;
        }
        Iterable<Integer> this$allRolls = this.getAllRolls();
        Iterable<Integer> other$allRolls = other.getAllRolls();
        if (this$allRolls == null ? other$allRolls != null : !this$allRolls.equals(other$allRolls)) {
            return false;
        }
        Dice this$dice = this.getDice();
        Dice other$dice = other.getDice();
        return !(this$dice == null ? other$dice != null : !this$dice.equals(other$dice));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $totalRoll = this.getTotalRoll();
        result = result * 59 + ($totalRoll == null ? 43 : ((Object)$totalRoll).hashCode());
        Iterable<Integer> $allRolls = this.getAllRolls();
        result = result * 59 + ($allRolls == null ? 43 : $allRolls.hashCode());
        Dice $dice = this.getDice();
        result = result * 59 + ($dice == null ? 43 : $dice.hashCode());
        return result;
    }

    public String toString() {
        return "DefaultRollResult(allRolls=" + this.getAllRolls() + ", dice=" + this.getDice() + ", totalRoll=" + this.getTotalRoll() + ")";
    }
}

