/*
 * Decompiled with CFR 0.152.
 */
package com.bernardomg.tabletop.dice.interpreter;

import com.bernardomg.tabletop.dice.interpreter.DiceInterpreter;
import com.bernardomg.tabletop.dice.notation.DiceNotationExpression;
import com.bernardomg.tabletop.dice.notation.operation.BinaryOperation;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InorderTraverser
implements DiceInterpreter<Iterable<DiceNotationExpression>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(InorderTraverser.class);

    @Override
    public final Iterable<DiceNotationExpression> transform(DiceNotationExpression expression) {
        Objects.requireNonNull(expression, "Received a null pointer as expression");
        DiceNotationExpression current = expression;
        Stack<DiceNotationExpression> nodes = new Stack<DiceNotationExpression>();
        ArrayList<DiceNotationExpression> exps = new ArrayList<DiceNotationExpression>();
        while (!nodes.isEmpty() || current != null) {
            LOGGER.debug("Transforming current node {}", (Object)current);
            if (current == null) {
                current = (DiceNotationExpression)nodes.pop();
                LOGGER.debug("No current node. Recovered {} from stack", (Object)current);
                LOGGER.debug("Stored current node {} into return", (Object)current);
                exps.add(current);
                if (current instanceof BinaryOperation) {
                    current = ((BinaryOperation)current).getRight();
                    LOGGER.trace("Moved to right node {}", (Object)current);
                    continue;
                }
                current = null;
                continue;
            }
            nodes.push(current);
            LOGGER.trace("Pushed node into stack");
            if (current instanceof BinaryOperation) {
                current = ((BinaryOperation)current).getLeft();
                LOGGER.trace("Moved to left node {}", (Object)current);
                continue;
            }
            current = null;
        }
        return exps;
    }
}

