/*
 * Decompiled with CFR 0.152.
 */
package com.bernardomg.tabletop.dice.interpreter;

import com.bernardomg.tabletop.dice.interpreter.DiceInterpreter;
import com.bernardomg.tabletop.dice.interpreter.ExpressionWrapper;
import com.bernardomg.tabletop.dice.notation.DiceNotationExpression;
import com.bernardomg.tabletop.dice.notation.operation.BinaryOperation;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Stack;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PostorderTraverser
implements DiceInterpreter<Iterable<DiceNotationExpression>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PostorderTraverser.class);

    @Override
    public final Iterable<DiceNotationExpression> transform(DiceNotationExpression expression) {
        Objects.requireNonNull(expression, "Received a null pointer as expression");
        Stack<DiceNotationExpression> nodes = new Stack<DiceNotationExpression>();
        nodes.push(expression);
        ArrayList<DiceNotationExpression> exps = new ArrayList<DiceNotationExpression>();
        while (!nodes.isEmpty()) {
            DiceNotationExpression current = (DiceNotationExpression)nodes.pop();
            LOGGER.debug("Transforming current node {}", (Object)current);
            if (current instanceof BinaryOperation) {
                LOGGER.trace("The current node is a binary node");
                LOGGER.trace("Pushing node and branches into stack");
                nodes.push(new ExpressionWrapper(current));
                nodes.push(((BinaryOperation)current).getRight());
                nodes.push(((BinaryOperation)current).getLeft());
                continue;
            }
            LOGGER.trace("The current node is a leaf node");
            LOGGER.debug("Stored current node {} into return", (Object)current);
            exps.add(current);
        }
        return exps.stream().map(this::unwrap).collect(Collectors.toList());
    }

    private final DiceNotationExpression unwrap(DiceNotationExpression expression) {
        DiceNotationExpression result = expression instanceof ExpressionWrapper ? ((ExpressionWrapper)expression).getWrappedExpression() : expression;
        return result;
    }
}

