/*
 * Decompiled with CFR 0.152.
 */
package com.bernardomg.tabletop.dice.interpreter;

import com.bernardomg.tabletop.dice.interpreter.DiceInterpreter;
import com.bernardomg.tabletop.dice.notation.DiceNotationExpression;
import com.bernardomg.tabletop.dice.notation.operation.BinaryOperation;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PreorderTraverser
implements DiceInterpreter<Iterable<DiceNotationExpression>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PreorderTraverser.class);

    @Override
    public final Iterable<DiceNotationExpression> transform(DiceNotationExpression expression) {
        Objects.requireNonNull(expression, "Received a null pointer as expression");
        Stack<DiceNotationExpression> nodes = new Stack<DiceNotationExpression>();
        nodes.push(expression);
        ArrayList<DiceNotationExpression> exps = new ArrayList<DiceNotationExpression>();
        while (!nodes.empty()) {
            DiceNotationExpression current = (DiceNotationExpression)nodes.pop();
            LOGGER.debug("Transforming current node {}", (Object)current);
            LOGGER.debug("Stored current node {} into return", (Object)current);
            exps.add(current);
            if (!(current instanceof BinaryOperation)) continue;
            LOGGER.trace("The current node is a binary node");
            LOGGER.trace("Pushing branches into stack");
            nodes.push(((BinaryOperation)current).getRight());
            nodes.push(((BinaryOperation)current).getLeft());
        }
        return exps;
    }
}

