/*
 * Decompiled with CFR 0.152.
 */
package com.bernardomg.tabletop.dice.notation.operation;

import com.bernardomg.tabletop.dice.notation.DiceNotationExpression;
import com.bernardomg.tabletop.dice.notation.operation.BinaryOperation;
import java.util.function.BiFunction;
import lombok.NonNull;

public abstract class AbstractBinaryOperation
implements BinaryOperation {
    @NonNull
    private final DiceNotationExpression left;
    @NonNull
    private final BiFunction<Integer, Integer, Integer> operation;
    @NonNull
    private final DiceNotationExpression right;

    public AbstractBinaryOperation(@NonNull DiceNotationExpression leftOperand, @NonNull DiceNotationExpression rightOperand, @NonNull BiFunction<Integer, Integer, Integer> func) {
        if (leftOperand == null) {
            throw new NullPointerException("leftOperand is marked non-null but is null");
        }
        if (rightOperand == null) {
            throw new NullPointerException("rightOperand is marked non-null but is null");
        }
        if (func == null) {
            throw new NullPointerException("func is marked non-null but is null");
        }
        this.left = leftOperand;
        this.right = rightOperand;
        this.operation = func;
    }

    @Override
    @NonNull
    public DiceNotationExpression getLeft() {
        return this.left;
    }

    @Override
    @NonNull
    public BiFunction<Integer, Integer, Integer> getOperation() {
        return this.operation;
    }

    @Override
    @NonNull
    public DiceNotationExpression getRight() {
        return this.right;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractBinaryOperation)) {
            return false;
        }
        AbstractBinaryOperation other = (AbstractBinaryOperation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        DiceNotationExpression this$left = this.getLeft();
        DiceNotationExpression other$left = other.getLeft();
        if (this$left == null ? other$left != null : !this$left.equals(other$left)) {
            return false;
        }
        BiFunction<Integer, Integer, Integer> this$operation = this.getOperation();
        BiFunction<Integer, Integer, Integer> other$operation = other.getOperation();
        if (this$operation == null ? other$operation != null : !this$operation.equals(other$operation)) {
            return false;
        }
        DiceNotationExpression this$right = this.getRight();
        DiceNotationExpression other$right = other.getRight();
        return !(this$right == null ? other$right != null : !this$right.equals(other$right));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractBinaryOperation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DiceNotationExpression $left = this.getLeft();
        result = result * 59 + ($left == null ? 43 : $left.hashCode());
        BiFunction<Integer, Integer, Integer> $operation = this.getOperation();
        result = result * 59 + ($operation == null ? 43 : $operation.hashCode());
        DiceNotationExpression $right = this.getRight();
        result = result * 59 + ($right == null ? 43 : $right.hashCode());
        return result;
    }

    public String toString() {
        return "AbstractBinaryOperation(left=" + this.getLeft() + ", operation=" + this.getOperation() + ", right=" + this.getRight() + ")";
    }
}

