/*
 * Decompiled with CFR 0.152.
 */
package com.bernardomg.tabletop.dice.parser.listener;

import com.bernardomg.tabletop.dice.DefaultDice;
import com.bernardomg.tabletop.dice.generated.DiceNotationBaseListener;
import com.bernardomg.tabletop.dice.generated.DiceNotationParser;
import com.bernardomg.tabletop.dice.notation.DiceNotationExpression;
import com.bernardomg.tabletop.dice.notation.operand.DefaultDiceOperand;
import com.bernardomg.tabletop.dice.notation.operand.DiceOperand;
import com.bernardomg.tabletop.dice.notation.operand.IntegerOperand;
import com.bernardomg.tabletop.dice.notation.operation.AbstractBinaryOperation;
import com.bernardomg.tabletop.dice.notation.operation.AdditionOperation;
import com.bernardomg.tabletop.dice.notation.operation.DivisionOperation;
import com.bernardomg.tabletop.dice.notation.operation.MultiplicationOperation;
import com.bernardomg.tabletop.dice.notation.operation.SubtractionOperation;
import com.bernardomg.tabletop.dice.parser.listener.DiceExpressionBuilder;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Stack;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultDiceExpressionBuilder
extends DiceNotationBaseListener
implements DiceExpressionBuilder {
    private static final String ADDITION_OPERATOR = "+";
    private static final String DIVISION_OPERATOR = "/";
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultDiceExpressionBuilder.class);
    private static final String MULTIPLICATION_OPERATOR = "*";
    private static final String SUBTRACTION_OPERATOR = "-";
    private final Stack<DiceNotationExpression> nodes = new Stack();

    @Override
    public final void exitAddOp(DiceNotationParser.AddOpContext ctx) {
        Objects.requireNonNull(ctx, "Received a null pointer as context");
        Collection operators = ctx.ADDOPERATOR().stream().map(ParseTree::getText).collect(Collectors.toList());
        DiceNotationExpression expression = this.getBinaryOperation(operators);
        LOGGER.debug("Parsed addition operation: {}", (Object)expression);
        this.nodes.push(expression);
    }

    @Override
    public final void exitDice(DiceNotationParser.DiceContext ctx) {
        Objects.requireNonNull(ctx, "Received a null pointer as context");
        DiceOperand expression = this.getDiceOperand(ctx);
        LOGGER.debug("Parsed dice: {}", (Object)expression);
        this.nodes.push(expression);
    }

    @Override
    public final void exitMultOp(DiceNotationParser.MultOpContext ctx) {
        Objects.requireNonNull(ctx, "Received a null pointer as context");
        Collection operators = ctx.MULTOPERATOR().stream().map(ParseTree::getText).collect(Collectors.toList());
        DiceNotationExpression expression = this.getBinaryOperation(operators);
        LOGGER.debug("Parsed multiplication operation: {}", (Object)expression);
        this.nodes.push(expression);
    }

    @Override
    public final void exitNumber(DiceNotationParser.NumberContext ctx) {
        Objects.requireNonNull(ctx, "Received a null pointer as context");
        IntegerOperand expression = this.getIntegerOperand(ctx.getText());
        LOGGER.debug("Parsed number: {}", (Object)expression);
        this.nodes.push(expression);
    }

    @Override
    public final DiceNotationExpression getDiceExpressionRoot() {
        DiceNotationExpression root;
        if (this.nodes.isEmpty()) {
            LOGGER.trace("No nodes. Returning null");
            root = null;
        } else {
            root = this.nodes.peek();
        }
        return root;
    }

    private final DiceNotationExpression getBinaryOperation(Collection<String> operators) {
        Stack<DiceNotationExpression> operands = new Stack<DiceNotationExpression>();
        Integer i = 0;
        while (i <= operators.size()) {
            operands.push(this.nodes.pop());
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        for (String operator : operators) {
            AbstractBinaryOperation operation;
            DiceNotationExpression left = (DiceNotationExpression)operands.pop();
            DiceNotationExpression right = (DiceNotationExpression)operands.pop();
            if (ADDITION_OPERATOR.equals(operator)) {
                LOGGER.trace("Addition operation");
                operation = new AdditionOperation(left, right);
            } else if (SUBTRACTION_OPERATOR.equals(operator)) {
                LOGGER.trace("Subtraction operation");
                operation = new SubtractionOperation(left, right);
            } else if (MULTIPLICATION_OPERATOR.equals(operator)) {
                LOGGER.trace("Multiplication operation");
                operation = new MultiplicationOperation(left, right);
            } else if (DIVISION_OPERATOR.equals(operator)) {
                LOGGER.trace("Division operation");
                operation = new DivisionOperation(left, right);
            } else {
                LOGGER.error("Unknown operator {}", (Object)operator);
                throw new IllegalArgumentException(String.format("The %s operator is invalid", operator));
            }
            LOGGER.debug("Parsed operation {}", (Object)operation);
            operands.push(operation);
        }
        return (DiceNotationExpression)operands.pop();
    }

    private final DiceOperand getDiceOperand(DiceNotationParser.DiceContext ctx) {
        Integer quantity;
        Iterator<TerminalNode> digits = ctx.DIGIT().iterator();
        long size = StreamSupport.stream(ctx.DIGIT().spliterator(), false).count();
        if (size > 1L) {
            if (ctx.ADDOPERATOR() != null && SUBTRACTION_OPERATOR.equals(ctx.ADDOPERATOR().getText())) {
                LOGGER.debug("This is part of a subtraction. Reversing sign.");
                quantity = 0 - Integer.parseInt(digits.next().getText());
            } else {
                quantity = Integer.parseInt(digits.next().getText());
            }
        } else {
            LOGGER.trace("No dice quantity defined. Defaulting to 1");
            quantity = 1;
        }
        Integer sides = Integer.parseInt(digits.next().getText());
        DefaultDice dice = new DefaultDice(quantity, sides);
        return new DefaultDiceOperand(dice);
    }

    private final IntegerOperand getIntegerOperand(String expression) {
        Integer value = Integer.parseInt(expression);
        return new IntegerOperand(value);
    }
}

