/*
 * Decompiled with CFR 0.152.
 */
package com.bernardomg.tabletop.dice.visitor;

import com.bernardomg.tabletop.dice.DefaultDice;
import com.bernardomg.tabletop.dice.Dice;
import com.bernardomg.tabletop.dice.notation.operand.ConstantOperand;
import com.bernardomg.tabletop.dice.notation.operand.DiceOperand;
import com.bernardomg.tabletop.dice.notation.operation.BinaryOperation;
import com.bernardomg.tabletop.dice.notation.operation.SubtractionOperation;
import com.bernardomg.tabletop.dice.visitor.NotationAccumulator;
import java.util.ArrayList;
import java.util.Collection;

public final class DiceAccumulator
implements NotationAccumulator<Iterable<Dice>> {
    private final Collection<Dice> dice = new ArrayList<Dice>();
    private Boolean negative = false;

    @Override
    public final void binaryOperation(BinaryOperation exp) {
        this.negative = exp instanceof SubtractionOperation ? Boolean.valueOf(true) : Boolean.valueOf(false);
    }

    @Override
    public final void constantOperand(ConstantOperand exp) {
        this.negative = false;
    }

    @Override
    public final void diceOperand(DiceOperand exp) {
        if (this.negative.booleanValue()) {
            this.dice.add(this.reverse(exp.getDice()));
        } else {
            this.dice.add(exp.getDice());
        }
    }

    @Override
    public final Iterable<Dice> getValue() {
        return this.dice;
    }

    @Override
    public final void reset() {
        this.negative = false;
        this.dice.clear();
    }

    private final Dice reverse(Dice d) {
        return new DefaultDice(0 - d.getQuantity(), d.getSides());
    }
}

