/*
 * Decompiled with CFR 0.152.
 */
package com.bernardomg.tabletop.dice.visitor;

import com.bernardomg.tabletop.dice.Dice;
import com.bernardomg.tabletop.dice.history.DefaultRollHistory;
import com.bernardomg.tabletop.dice.history.DefaultRollResult;
import com.bernardomg.tabletop.dice.history.RollHistory;
import com.bernardomg.tabletop.dice.history.RollResult;
import com.bernardomg.tabletop.dice.notation.DiceNotationExpression;
import com.bernardomg.tabletop.dice.notation.operand.ConstantOperand;
import com.bernardomg.tabletop.dice.notation.operand.DiceOperand;
import com.bernardomg.tabletop.dice.notation.operation.AdditionOperation;
import com.bernardomg.tabletop.dice.notation.operation.BinaryOperation;
import com.bernardomg.tabletop.dice.notation.operation.DivisionOperation;
import com.bernardomg.tabletop.dice.notation.operation.MultiplicationOperation;
import com.bernardomg.tabletop.dice.notation.operation.SubtractionOperation;
import com.bernardomg.tabletop.dice.visitor.NotationAccumulator;
import java.util.Objects;
import java.util.Stack;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DiceRollAccumulator
implements NotationAccumulator<RollHistory> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DiceRollAccumulator.class);
    private DiceNotationExpression previous;
    private final Stack<RollResult> results = new Stack();
    private final Function<Dice, RollResult> rollGenerator;
    private final Stack<String> texts = new Stack();
    private final Stack<Integer> values = new Stack();

    public DiceRollAccumulator(Function<Dice, RollResult> generator) {
        this.rollGenerator = Objects.requireNonNull(generator, "Received a null pointer as roll generator");
    }

    @Override
    public final void binaryOperation(BinaryOperation exp) {
        Integer operandB = this.values.pop();
        Integer operandA = this.values.pop();
        BiFunction<Integer, Integer, Integer> operation = exp.getOperation();
        Integer value = operation.apply(operandA, operandB);
        this.values.push(value);
        String op = this.getOperationText(exp);
        String textA = this.texts.pop();
        String textB = this.texts.pop();
        this.texts.push(textB + op + textA);
        if (exp instanceof SubtractionOperation && this.previous instanceof ConstantOperand) {
            RollResult rollResult = this.results.pop();
            value = 0 - rollResult.getTotalRoll();
            rollResult = new DefaultRollResult(value);
            this.results.push(rollResult);
        }
        this.previous = exp;
    }

    @Override
    public final void constantOperand(ConstantOperand exp) {
        Integer value = exp.getValue();
        DefaultRollResult rollResult = new DefaultRollResult(value);
        this.results.add(rollResult);
        this.values.push(rollResult.getTotalRoll());
        this.texts.push(rollResult.getTotalRoll().toString());
        this.previous = exp;
    }

    @Override
    public final void diceOperand(DiceOperand exp) {
        RollResult rollResult = this.rollGenerator.apply(exp.getDice());
        this.results.add(rollResult);
        this.values.push(rollResult.getTotalRoll());
        Long totalRolls = StreamSupport.stream(rollResult.getAllRolls().spliterator(), false).count();
        if (totalRolls > 1L) {
            this.texts.push(rollResult.getAllRolls().toString());
        } else {
            this.texts.push(rollResult.getTotalRoll().toString());
        }
        this.previous = exp;
    }

    @Override
    public final RollHistory getValue() {
        Integer result = this.values.isEmpty() ? Integer.valueOf(0) : this.values.pop();
        String text = this.texts.isEmpty() ? "" : this.texts.pop();
        return new DefaultRollHistory(this.results, text, result);
    }

    @Override
    public final void reset() {
        this.previous = null;
        this.results.clear();
        this.texts.clear();
        this.values.clear();
    }

    private final String getOperationText(BinaryOperation exp) {
        String text;
        if (exp instanceof AdditionOperation) {
            text = " + ";
        } else if (exp instanceof SubtractionOperation) {
            text = " - ";
        } else if (exp instanceof MultiplicationOperation) {
            text = " * ";
        } else if (exp instanceof DivisionOperation) {
            text = " / ";
        } else {
            LOGGER.warn("Unsupported expression of type {}", exp.getClass());
            text = "";
        }
        return text;
    }
}

