/*
 * Decompiled with CFR 0.152.
 */
package com.bernardomg.tabletop.dice.interpreter;

import com.bernardomg.tabletop.dice.interpreter.DiceInterpreter;
import com.bernardomg.tabletop.dice.notation.DiceNotationExpression;
import com.bernardomg.tabletop.dice.notation.operand.ConstantOperand;
import com.bernardomg.tabletop.dice.notation.operand.DiceOperand;
import com.bernardomg.tabletop.dice.notation.operation.BinaryOperation;
import com.bernardomg.tabletop.dice.visitor.NotationAccumulator;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigurableInterpreter<V>
implements DiceInterpreter<V> {
    private static final Logger log = LoggerFactory.getLogger(ConfigurableInterpreter.class);
    private final NotationAccumulator<V> accumulator;
    private final DiceInterpreter<Iterable<DiceNotationExpression>> traverser;

    public ConfigurableInterpreter(DiceInterpreter<Iterable<DiceNotationExpression>> trav, NotationAccumulator<V> accum) {
        this.traverser = Objects.requireNonNull(trav, "Received a null pointer as traverser");
        this.accumulator = Objects.requireNonNull(accum, "Received a null pointer as accumulator");
    }

    @Override
    public final V transform(DiceNotationExpression expression) {
        Objects.requireNonNull(expression, "Received a null pointer as expression");
        log.debug("Root expression {}", (Object)expression);
        Iterable<DiceNotationExpression> exps = this.traverser.transform(expression);
        log.trace("Traversed root into {}", exps);
        V result = this.process(exps);
        log.trace("Processed expressions into {}", result);
        return result;
    }

    private final V process(Iterable<DiceNotationExpression> nodes) {
        this.accumulator.reset();
        for (DiceNotationExpression current : nodes) {
            log.debug("Current expression: {}", (Object)current);
            if (current instanceof BinaryOperation) {
                this.accumulator.binaryOperation((BinaryOperation)current);
                continue;
            }
            if (current instanceof ConstantOperand) {
                this.accumulator.constantOperand((ConstantOperand)current);
                continue;
            }
            if (current instanceof DiceOperand) {
                this.accumulator.diceOperand((DiceOperand)current);
                continue;
            }
            log.warn("Unsupported expression of type {}", current.getClass());
        }
        return this.accumulator.getValue();
    }
}

